/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.util;

public final class AudioUtil {
    public static short[] bytesToShorts(byte[] bytes) {
        short[] shorts = new short[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            shorts[i / 2] = AudioUtil.bytesToShort(bytes[i], bytes[i + 1]);
        }
        return shorts;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] bytes = new byte[shorts.length * 2];
        for (int i = 0; i < bytes.length; i += 2) {
            byte[] sample2 = AudioUtil.shortToBytes(shorts[i / 2]);
            bytes[i] = sample2[0];
            bytes[i + 1] = sample2[1];
        }
        return bytes;
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static short[] floatsToShorts(float[] floats) {
        short[] shorts = new short[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            shorts[i] = Float.valueOf(Math.min(32767.0f, Math.max(-32768.0f, floats[i]))).shortValue();
        }
        return shorts;
    }

    public static float[] shortsToFloats(short[] input) {
        float[] ret = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            ret[i] = Short.valueOf(input[i]).floatValue();
        }
        return ret;
    }

    public static boolean containsMinAudioLevel(byte[] samples, double minAudioLevel) {
        for (int i = 0; i < samples.length; i += 100) {
            double level = AudioUtil.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level >= minAudioLevel)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMinAudioLevel(short[] samples, double minAudioLevel) {
        for (int i = 0; i < samples.length; i += 50) {
            double level = AudioUtil.calculateAudioLevel(samples, i, Math.min(i + 50, samples.length));
            if (!(level >= minAudioLevel)) continue;
            return true;
        }
        return false;
    }

    public static double calculateAudioLevel(byte[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; i += 2) {
            double sample2 = (double)AudioUtil.bytesToShort(samples[i], samples[i + 1]) / 32767.0;
            rms += sample2 * sample2;
        }
        return AudioUtil.calculateAudioLevelFromRMS(rms, samples.length / 2);
    }

    public static double calculateAudioLevel(short[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; ++i) {
            double sample2 = (double)samples[i] / 32767.0;
            rms += sample2 * sample2;
        }
        return AudioUtil.calculateAudioLevelFromRMS(rms, samples.length);
    }

    public static double calculateAudioLevelFromRMS(double rms, int sampleCount) {
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    public static double calculateHighestAudioLevel(short[] samples) {
        double highest = -127.0;
        for (int i = 0; i < samples.length; i += 50) {
            double level = AudioUtil.calculateAudioLevel(samples, i, Math.min(i + 50, samples.length));
            if (!(level > highest)) continue;
            highest = level;
        }
        return highest;
    }

    public static double audioLevelToDoubleRange(double audioLevel) {
        return 1.0 - Math.max(-60.0, audioLevel) / -60.0;
    }

    public static double doubleRangeToAudioLevel(double value) {
        return Math.round((1.0 - value) * -60.0);
    }

    public static byte[] convertToMonoBytes(short[] samples) {
        byte[] mono = new byte[samples.length];
        for (int i = 0; i < samples.length; i += 2) {
            byte[] monoSample = AudioUtil.shortToBytes((short)(samples[i] + samples[i + 1]));
            mono[i] = monoSample[0];
            mono[i + 1] = monoSample[1];
        }
        return mono;
    }

    public static short[] convertToMonoShorts(short[] samples) {
        short[] mono = new short[samples.length / 2];
        for (int i = 0; i < samples.length; i += 2) {
            mono[i / 2] = (short)((samples[i] + samples[i + 1]) / 2);
        }
        return mono;
    }

    public static short getHighestAbsoluteSample(short[] samples) {
        short max = 0;
        for (short sample2 : samples) {
            short abs;
            if (sample2 == Short.MIN_VALUE) {
                sample2 = (short)(sample2 + 1);
            }
            if ((abs = (short)Math.abs(sample2)) <= max) continue;
            max = abs;
        }
        return max;
    }

    public static float[] shortsToFloatsRange(short[] input) {
        float[] floats = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floats[i] = (float)input[i] / 32768.0f;
        }
        return floats;
    }

    public static short[] floatsRangeToShort(float[] input) {
        short[] shorts = new short[input.length];
        for (int i = 0; i < input.length; ++i) {
            shorts[i] = (short)(input[i] * 32768.0f);
        }
        return shorts;
    }

    public static float mulToDB(float mul) {
        return mul == 0.0f ? -3.4028235E38f : (float)(20.0 * Math.log10(mul));
    }

    public static float dbToMul(float db) {
        return Float.isFinite(db) ? (float)Math.pow(10.0, db / 20.0f) : 0.0f;
    }

    public static double dbToMul(double db) {
        return Double.isFinite(db) ? (double)((float)Math.pow(10.0, db / 20.0)) : 0.0;
    }

    public static float gainCoefficient(int sampleRate, float time) {
        return (float)Math.exp(-1.0f / ((float)sampleRate * time));
    }

    public static short[] fadeIn(short[] samples, int channels) {
        int fadeInDuration = samples.length;
        short[] processed = new short[samples.length];
        for (int index = 0; index < samples.length; index += channels) {
            float fade = Math.min((float)index / (float)fadeInDuration, 1.0f);
            for (int channel = 0; channel < channels; ++channel) {
                processed[index + channel] = (short)((float)samples[index + channel] * fade);
            }
        }
        return processed;
    }

    public static short[] fadeOut(short[] samples, int channels) {
        int fadeOutDuration = samples.length;
        short[] processed = new short[samples.length];
        for (int index = 0; index < samples.length; index += channels) {
            float fade = Math.max((float)(fadeOutDuration - index) / (float)fadeOutDuration, 0.0f);
            for (int channel = 0; channel < channels; ++channel) {
                processed[index + channel] = (short)((float)samples[index + channel] * fade);
            }
        }
        return processed;
    }

    private AudioUtil() {
    }
}

