/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.event.player.McPlayerQuitEvent;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.connection.UdpServerConnectionManager;
import su.plo.voice.api.server.event.connection.UdpClientConnectEvent;
import su.plo.voice.api.server.event.connection.UdpClientConnectedEvent;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.ClientPacketUdpHandler;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceUdpServerConnectionManager
implements UdpServerConnectionManager {
    private final BaseVoiceServer voiceServer;
    private final Map<UUID, UUID> secretByPlayerId = Maps.newConcurrentMap();
    private final Map<UUID, UUID> playerIdBySecret = Maps.newConcurrentMap();
    private final Map<UUID, UdpServerConnection> connectionBySecret = Maps.newConcurrentMap();
    private final Map<UUID, UdpServerConnection> connectionByPlayerId = Maps.newConcurrentMap();

    public VoiceUdpServerConnectionManager(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        McPlayerQuitEvent.INSTANCE.registerListener(player -> this.getConnectionByPlayerId(player.getUuid()).ifPresent(connection -> this.removeConnection((UdpServerConnection)connection, UdpClientDisconnectedEvent.Reason.DISCONNECT)));
    }

    @Override
    public Optional<UUID> getPlayerIdBySecret(@NonNull UUID secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        return Optional.ofNullable(this.playerIdBySecret.get(secret));
    }

    @Override
    @NotNull
    public UUID getSecretByPlayerId(@NonNull UUID playerUUID) {
        if (playerUUID == null) {
            throw new NullPointerException("playerUUID is marked non-null but is null");
        }
        if (this.secretByPlayerId.containsKey(playerUUID)) {
            return this.secretByPlayerId.get(playerUUID);
        }
        UUID secret = UUID.randomUUID();
        this.secretByPlayerId.put(playerUUID, secret);
        this.playerIdBySecret.put(secret, playerUUID);
        return secret;
    }

    @Override
    public void addConnection(@NonNull UdpServerConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        UdpClientConnectEvent connectEvent = new UdpClientConnectEvent(connection);
        if (!this.voiceServer.getEventBus().fire(connectEvent)) {
            return;
        }
        UdpServerConnection bySecret = this.connectionBySecret.put(connection.getSecret(), connection);
        UdpServerConnection byPlayer = this.connectionByPlayerId.put(connection.getPlayer().getInstance().getUuid(), connection);
        if (bySecret != null) {
            bySecret.disconnect();
        }
        if (byPlayer != null) {
            byPlayer.disconnect();
        }
        BaseVoice.DEBUG_LOGGER.log("{} ({}) connected", connection.getPlayer().getInstance().getName(), connection.getRemoteAddress());
        this.voiceServer.getEventBus().fire(new UdpClientConnectedEvent(connection));
    }

    @Override
    public boolean removeConnection(@NonNull UdpServerConnection connection, @NotNull UdpClientDisconnectedEvent.Reason reason) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        UdpServerConnection bySecret = this.connectionBySecret.remove(connection.getSecret());
        UdpServerConnection byPlayer = this.connectionByPlayerId.remove(connection.getPlayer().getInstance().getUuid());
        if (bySecret != null) {
            this.disconnect(bySecret, reason);
        }
        if (byPlayer != null && !byPlayer.equals(bySecret)) {
            this.disconnect(byPlayer, reason);
        }
        return bySecret != null || byPlayer != null;
    }

    @Override
    public boolean removeConnection(@NotNull VoiceServerPlayer player, @NotNull UdpClientDisconnectedEvent.Reason reason) {
        UdpServerConnection connection = this.connectionByPlayerId.remove(player.getInstance().getUuid());
        if (connection != null) {
            this.disconnect(connection, reason);
        }
        return connection != null;
    }

    @Override
    public boolean removeConnection(@NotNull UUID secret, @NotNull UdpClientDisconnectedEvent.Reason reason) {
        UdpServerConnection connection = this.connectionBySecret.remove(secret);
        if (connection != null) {
            this.disconnect(connection, reason);
        }
        return connection != null;
    }

    @Override
    public Optional<UdpServerConnection> getConnectionBySecret(@NotNull UUID secret) {
        return Optional.ofNullable(this.connectionBySecret.get(secret));
    }

    @Override
    public Optional<UdpServerConnection> getConnectionByPlayerId(@NotNull UUID playerId) {
        return Optional.ofNullable(this.connectionByPlayerId.get(playerId));
    }

    @Override
    public Collection<UdpServerConnection> getConnections() {
        return this.connectionByPlayerId.values();
    }

    @Override
    public void clearConnections() {
        this.getConnections().forEach(connection -> this.removeConnection((UdpServerConnection)connection, UdpClientDisconnectedEvent.Reason.DISCONNECT));
    }

    private void disconnect(@NotNull UdpServerConnection connection, @NotNull UdpClientDisconnectedEvent.Reason reason) {
        if (!connection.isConnected()) {
            return;
        }
        connection.disconnect();
        VoiceServerPlayer player = connection.getPlayer();
        this.secretByPlayerId.remove(player.getInstance().getUuid());
        this.playerIdBySecret.remove(connection.getSecret());
        this.connectionByPlayerId.remove(player.getInstance().getUuid());
        this.connectionBySecret.remove(connection.getSecret());
        BaseVoice.DEBUG_LOGGER.log("{} disconnected {}", new Object[]{connection.getPlayer().getInstance().getName(), reason});
        this.voiceServer.getEventBus().fire(new UdpClientDisconnectedEvent(connection, reason));
    }

    @Override
    public void broadcast(@NotNull Packet<ClientPacketUdpHandler> packet, @Nullable Predicate<VoiceServerPlayer> filter2) {
        for (UdpServerConnection connection : this.getConnections()) {
            if (filter2 != null && !filter2.test(connection.getPlayer())) continue;
            connection.sendPacket(packet);
        }
    }
}

