/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DelayedFullDataSourceSaveCache
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadPoolExecutor BACKGROUND_CLEAN_UP_THREAD = ThreadUtil.makeSingleDaemonThreadPool("delayed save cache cleaner");
    private static final Set<WeakReference<DelayedFullDataSourceSaveCache>> SAVE_CACHE_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int CLEANUP_CHECK_TIME_IN_MS = 1000;
    private final ConcurrentHashMap<Long, DataSourceSavedTimePair> dataSourceByPosition = new ConcurrentHashMap();
    protected final KeyedLockContainer<Long> saveLockContainer = new KeyedLockContainer();
    private final ISaveDataSourceFunc onSaveTimeoutAsyncFunc;
    private final int saveDelayInMs;

    public DelayedFullDataSourceSaveCache(@NotNull ISaveDataSourceFunc onSaveTimeoutAsyncFunc, int saveDelayInMs) {
        this.onSaveTimeoutAsyncFunc = onSaveTimeoutAsyncFunc;
        if (saveDelayInMs < 1000) {
            LOGGER.warn("The save delay [" + saveDelayInMs + "] shouldn't be less than the cleanup check timer interval [" + 1000 + "].");
        }
        this.saveDelayInMs = saveDelayInMs;
        SAVE_CACHE_SET.add(new WeakReference<DelayedFullDataSourceSaveCache>(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataSourceToMemoryAndQueueSave(@NotNull FullDataSourceV2 inputDataSource) {
        long inputPos = inputDataSource.getPos();
        ReentrantLock lockForPos = this.saveLockContainer.getLockForPos(inputPos);
        try {
            FullDataSourceV2 memoryDataSource;
            lockForPos.lock();
            DataSourceSavedTimePair pair = this.dataSourceByPosition.getOrDefault(inputPos, null);
            if (pair == null) {
                memoryDataSource = FullDataSourceV2.createEmpty(inputPos);
                pair = new DataSourceSavedTimePair(memoryDataSource);
                this.dataSourceByPosition.put(inputPos, pair);
            } else {
                memoryDataSource = pair.dataSource;
            }
            memoryDataSource.update(inputDataSource);
            pair.updateLastWrittenTimestamp();
        }
        finally {
            lockForPos.unlock();
        }
    }

    public void handleDataSourceRemoval(@NotNull FullDataSourceV2 removedDataSource) {
        this.onSaveTimeoutAsyncFunc.saveAsync(removedDataSource).handle((voidObj, throwable) -> {
            try {
                removedDataSource.close();
            }
            catch (Exception e) {
                LOGGER.error("Unable to close datasource [" + DhSectionPos.toString(removedDataSource.getPos()) + "], error: [" + e.getMessage() + "].", (Throwable)e);
            }
            return null;
        });
    }

    public int getUnsavedCount() {
        return this.dataSourceByPosition.size();
    }

    public void flush() {
        this.cleanUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(boolean flushAll) {
        Enumeration<Long> keyIterator = this.dataSourceByPosition.keys();
        while (keyIterator.hasMoreElements()) {
            Long pos = keyIterator.nextElement();
            ReentrantLock posLock = this.saveLockContainer.getLockForPos(pos);
            try {
                posLock.lock();
                DataSourceSavedTimePair savedPair = this.dataSourceByPosition.getOrDefault(pos, null);
                if (savedPair == null || !flushAll && !savedPair.dataSourceHasTimedOut(this.saveDelayInMs)) continue;
                this.dataSourceByPosition.remove(pos);
                this.handleDataSourceRemoval(savedPair.dataSource);
            }
            finally {
                posLock.unlock();
            }
        }
    }

    private static void runCleanupLoop() {
        while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SAVE_CACHE_SET.forEach(cacheRef -> {
                        DelayedFullDataSourceSaveCache cache = (DelayedFullDataSourceSaveCache)cacheRef.get();
                        if (cache == null) {
                            SAVE_CACHE_SET.remove(cacheRef);
                        } else {
                            cache.cleanUp(false);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in cleanup thread: [" + e.getMessage() + "].", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        SAVE_CACHE_SET.removeIf(cacheRef -> {
            DelayedFullDataSourceSaveCache cache = (DelayedFullDataSourceSaveCache)cacheRef.get();
            return cache != null && cache.equals(this);
        });
    }

    static {
        BACKGROUND_CLEAN_UP_THREAD.execute(() -> DelayedFullDataSourceSaveCache.runCleanupLoop());
    }

    @FunctionalInterface
    public static interface ISaveDataSourceFunc {
        public CompletableFuture<Void> saveAsync(FullDataSourceV2 var1);
    }

    private static class DataSourceSavedTimePair {
        @NotNull
        public final FullDataSourceV2 dataSource;
        public long lastWrittenDateTimeMs;

        public DataSourceSavedTimePair(@NotNull FullDataSourceV2 dataSource) {
            this.dataSource = dataSource;
            this.lastWrittenDateTimeMs = System.currentTimeMillis();
        }

        public void updateLastWrittenTimestamp() {
            this.lastWrittenDateTimeMs = System.currentTimeMillis();
        }

        public boolean dataSourceHasTimedOut(long msTillTimeout) {
            long currentTime = System.currentTimeMillis();
            long timeSinceUpdate = currentTime - this.lastWrittenDateTimeMs;
            return timeSinceUpdate > msTillTimeout;
        }
    }
}

