/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.joml.Vector4f;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final Minecraft MC = Minecraft.getInstance();
    private static final IOptifineAccessor OPTIFINE_ACCESSOR = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;
    private static FogRenderer mcFogRenderer = null;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        return new Vec3f(camera.getLookVector().x(), camera.getLookVector().y(), camera.getLookVector().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        if (MinecraftRenderWrapper.MC.player == null) {
            return false;
        }
        if (MinecraftRenderWrapper.MC.player.getActiveEffectsMap() == null) {
            return false;
        }
        return MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.BLINDNESS) != null || MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.DARKNESS) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        Vec3 projectedView = camera.getPosition();
        return new Vec3d(projectedView.x, projectedView.y, projectedView.z);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        if (mcFogRenderer == null) {
            mcFogRenderer = new FogRenderer();
        }
        if (MinecraftRenderWrapper.MC.level == null) {
            return Color.white;
        }
        boolean isFoggy = MinecraftRenderWrapper.MC.level.effects().isFoggyAt(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getBlockPosition().getX(), MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getBlockPosition().getZ()) || MinecraftRenderWrapper.MC.gui.getBossOverlay().shouldCreateWorldFog();
        Vector4f colorValues = mcFogRenderer.setupFog(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), MinecraftRenderWrapper.MC.options.getEffectiveRenderDistance(), isFoggy, (DeltaTracker)MinecraftRenderWrapper.MC.deltaTracker, MinecraftRenderWrapper.MC.gameRenderer.getDarkenWorldAmount(MinecraftRenderWrapper.MC.deltaTracker.getGameTimeDeltaPartialTick(true)), MinecraftRenderWrapper.MC.level);
        return new Color(Math.max(0.0f, Math.min(colorValues.x, 1.0f)), Math.max(0.0f, Math.min(colorValues.y, 1.0f)), Math.max(0.0f, Math.min(colorValues.z, 1.0f)), Math.max(0.0f, Math.min(colorValues.w, 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.level.dimensionType().hasSkyLight()) {
            float frameTime = MinecraftRenderWrapper.MC.deltaTracker.getGameTimeDeltaTicks();
            int argbColorInt = MinecraftRenderWrapper.MC.level.getSkyColor(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getPosition(), frameTime);
            return ColorUtil.toColorObjARGB(argbColorInt);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.gameRenderer.getFov(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.options.getEffectiveRenderDistance();
    }

    @Override
    public int getScreenWidth() {
        int width = MC.getWindow().getWidth();
        if (OPTIFINE_ACCESSOR != null) {
            width = (int)((double)width * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return width;
    }

    @Override
    public int getScreenHeight() {
        int height = MC.getWindow().getHeight();
        if (OPTIFINE_ACCESSOR != null) {
            height = (int)((double)height * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return height;
    }

    protected RenderTarget getRenderTarget() {
        return MC.getMainRenderTarget();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return false;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFrameBuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return 0;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        try {
            GlTexture glTexture = (GlTexture)this.getRenderTarget().getDepthTexture();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.glId();
        }
        catch (Exception e) {
            if (!this.depthTextureCastFailLogged) {
                this.depthTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target depth texture to GlTexture. MC or a rendering mod may have changed the object type.", (Throwable)e);
            }
            return 0;
        }
    }

    @Override
    public int getColorTextureId() {
        try {
            GlTexture glTexture = (GlTexture)this.getRenderTarget().getColorTexture();
            if (glTexture == null) {
                return 0;
            }
            return glTexture.glId();
        }
        catch (Exception e) {
            if (!this.colorTextureCastFailLogged) {
                this.colorTextureCastFailLogged = true;
                LOGGER.error("Unable to cast render Target color texture to GlTexture. MC or a rendering mod may have changed the object type.", (Throwable)e);
            }
            return 0;
        }
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().width;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().height;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getFluidInCamera() != FogType.NONE || isBlind;
    }

    public void updateLightmap(NativeImage lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }
}

