/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WorldGenStructFeatManager
extends StructureManager {
    final WorldGenLevel genLevel;
    WorldOptions worldOptions;
    StructureCheck structureCheck;

    public WorldGenStructFeatManager(WorldOptions worldOptions, WorldGenLevel genLevel, StructureCheck structureCheck) {
        super((LevelAccessor)genLevel, worldOptions, structureCheck);
        this.genLevel = genLevel;
        this.worldOptions = worldOptions;
    }

    public WorldGenStructFeatManager forWorldGenRegion(WorldGenRegion worldGenRegion) {
        if (worldGenRegion == this.genLevel) {
            return this;
        }
        return new WorldGenStructFeatManager(this.worldOptions, (WorldGenLevel)worldGenRegion, this.structureCheck);
    }

    private ChunkAccess _getChunk(int x, int z, ChunkStatus status) {
        if (this.genLevel == null) {
            return null;
        }
        return this.genLevel.getChunk(x, z, status, false);
    }

    public boolean hasAnyStructureAt(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.of((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        if (chunk == null) {
            return false;
        }
        return chunk.hasAnyStructureReferences();
    }

    public List<StructureStart> startsForStructure(ChunkPos sectionPos, Predicate<Structure> predicate) {
        ChunkAccess chunk = this._getChunk(sectionPos.x, sectionPos.z, ChunkStatus.STRUCTURE_REFERENCES);
        if (chunk == null) {
            return List.of();
        }
        Map map = chunk.getAllReferences();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : map.entrySet()) {
            Structure configuredStructureFeature = (Structure)entry.getKey();
            if (!predicate.test(configuredStructureFeature)) continue;
            LongSet var10002 = (LongSet)entry.getValue();
            Objects.requireNonNull(builder);
            this.fillStartsForStructure(configuredStructureFeature, var10002, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> startsForStructure(SectionPos sectionPos, Structure structure) {
        ChunkAccess chunk = this._getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        if (chunk == null) {
            return (List)((Object)Stream.empty());
        }
        LongSet longSet = chunk.getReferencesForStructure(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        this.fillStartsForStructure(structure, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Map<Structure, LongSet> getAllStructuresAt(BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.of((BlockPos)blockPos);
        ChunkAccess chunk = this._getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        if (chunk == null) {
            return (Map)((Object)Stream.empty());
        }
        return chunk.getAllReferences();
    }
}

