/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.lzma.Optimum;
import org.tukaani.xz.lzma.State;
import org.tukaani.xz.rangecoder.RangeEncoder;

final class LZMAEncoderNormal
extends LZMAEncoder {
    private static final int OPTS = 4096;
    private static final int EXTRA_SIZE_BEFORE = 4096;
    private static final int EXTRA_SIZE_AFTER = 4096;
    private final Optimum[] opts = new Optimum[4096];
    private int optCur = 0;
    private int optEnd = 0;
    private Matches matches;
    private final int[] repLens = new int[4];
    private final State nextState = new State();

    static int getMemoryUsage(int i, int j, int k) {
        return LZEncoder.getMemoryUsage(i, Math.max(j, 4096), 4096, 273, k) + 256;
    }

    LZMAEncoderNormal(RangeEncoder rangeEncoder, int i, int j, int k, int l, int m, int n, int o, int p, ArrayCache arrayCache) {
        super(rangeEncoder, LZEncoder.getInstance(l, Math.max(m, 4096), 4096, n, 273, o, p, arrayCache), i, j, k, l, n);
        for (int i2 = 0; i2 < 4096; ++i2) {
            this.opts[i2] = new Optimum();
        }
    }

    @Override
    public void reset() {
        this.optCur = 0;
        this.optEnd = 0;
        super.reset();
    }

    private int convertOpts() {
        this.optEnd = this.optCur;
        int n = this.opts[this.optCur].optPrev;
        do {
            Optimum optimum = this.opts[this.optCur];
            if (optimum.prev1IsLiteral) {
                this.opts[n].optPrev = this.optCur;
                this.opts[n].backPrev = -1;
                this.optCur = n--;
                if (optimum.hasPrev2) {
                    this.opts[n].optPrev = n + 1;
                    this.opts[n].backPrev = optimum.backPrev2;
                    this.optCur = n;
                    n = optimum.optPrev2;
                }
            }
            int n2 = this.opts[n].optPrev;
            this.opts[n].optPrev = this.optCur;
            this.optCur = n;
            n = n2;
        } while (this.optCur > 0);
        this.optCur = this.opts[0].optPrev;
        this.back = this.opts[this.optCur].backPrev;
        return this.optCur;
    }

    @Override
    int getNextSymbol() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.optCur < this.optEnd) {
            int n7 = this.opts[this.optCur].optPrev - this.optCur;
            this.optCur = this.opts[this.optCur].optPrev;
            this.back = this.opts[this.optCur].backPrev;
            return n7;
        }
        assert (this.optCur == this.optEnd);
        this.optCur = 0;
        this.optEnd = 0;
        this.back = -1;
        if (this.readAhead == -1) {
            this.matches = this.getMatches();
        }
        if ((n6 = Math.min(this.lz.getAvail(), 273)) < 2) {
            return 1;
        }
        int n8 = 0;
        for (n5 = 0; n5 < 4; ++n5) {
            this.repLens[n5] = this.lz.getMatchLen(this.reps[n5], n6);
            if (this.repLens[n5] < 2) {
                this.repLens[n5] = 0;
                continue;
            }
            if (this.repLens[n5] <= this.repLens[n8]) continue;
            n8 = n5;
        }
        if (this.repLens[n8] >= this.niceLen) {
            this.back = n8;
            this.skip(this.repLens[n8] - 1);
            return this.repLens[n8];
        }
        n5 = 0;
        int n9 = 0;
        if (this.matches.count > 0) {
            n5 = this.matches.len[this.matches.count - 1];
            n9 = this.matches.dist[this.matches.count - 1];
            if (n5 >= this.niceLen) {
                this.back = n9 + 4;
                this.skip(n5 - 1);
                return n5;
            }
        }
        int n10 = this.lz.getByte(0);
        int n11 = this.lz.getByte(this.reps[0] + 1);
        if (n5 < 2 && n10 != n11 && this.repLens[n8] < 2) {
            return 1;
        }
        int n12 = this.lz.getPos();
        int n13 = n12 & this.posMask;
        int n14 = this.lz.getByte(1);
        int n15 = this.literalEncoder.getPrice(n10, n11, n14, n12, this.state);
        this.opts[1].set1(n15, 0, -1);
        n14 = this.getAnyMatchPrice(this.state, n13);
        n15 = this.getAnyRepPrice(n14, this.state);
        if (n11 == n10 && (n4 = this.getShortRepPrice(n15, this.state, n13)) < this.opts[1].price) {
            this.opts[1].set1(n4, 0, 0);
        }
        this.optEnd = Math.max(n5, this.repLens[n8]);
        if (this.optEnd < 2) {
            assert (this.optEnd == 0) : this.optEnd;
            this.back = this.opts[1].backPrev;
            return 1;
        }
        this.updatePrices();
        this.opts[0].state.set(this.state);
        System.arraycopy(this.reps, 0, this.opts[0].reps, 0, 4);
        for (n4 = this.optEnd; n4 >= 2; --n4) {
            this.opts[n4].reset();
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = this.repLens[n4];
            if (n3 < 2) continue;
            n2 = this.getLongRepPrice(n15, n4, this.state, n13);
            do {
                if ((n = n2 + this.repLenEncoder.getPrice(n3, n13)) >= this.opts[n3].price) continue;
                this.opts[n3].set1(n, 0, n4);
            } while (--n3 >= 2);
        }
        n4 = Math.max(this.repLens[0] + 1, 2);
        if (n4 <= n5) {
            n3 = this.getNormalMatchPrice(n14, this.state);
            n2 = 0;
            while (n4 > this.matches.len[n2]) {
                ++n2;
            }
            while (true) {
                int n16;
                if ((n16 = this.getMatchAndLenPrice(n3, n = this.matches.dist[n2], n4, n13)) < this.opts[n4].price) {
                    this.opts[n4].set1(n16, 0, n + 4);
                }
                if (n4 == this.matches.len[n2] && ++n2 == this.matches.count) break;
                ++n4;
            }
        }
        n6 = Math.min(this.lz.getAvail(), 4095);
        while (++this.optCur < this.optEnd) {
            this.matches = this.getMatches();
            if (this.matches.count > 0 && this.matches.len[this.matches.count - 1] >= this.niceLen) break;
            n13 = ++n12 & this.posMask;
            this.updateOptStateAndReps();
            n14 = this.opts[this.optCur].price + this.getAnyMatchPrice(this.opts[this.optCur].state, n13);
            n15 = this.getAnyRepPrice(n14, this.opts[this.optCur].state);
            this.calc1BytePrices(n12, n13, --n6, n15);
            if (n6 < 2) continue;
            n4 = this.calcLongRepPrices(n12, n13, n6, n15);
            if (this.matches.count <= 0) continue;
            this.calcNormalMatchPrices(n12, n13, n6, n14, n4);
        }
        return this.convertOpts();
    }

    private void updateOptStateAndReps() {
        int n = this.opts[this.optCur].optPrev;
        assert (n < this.optCur);
        if (this.opts[this.optCur].prev1IsLiteral) {
            --n;
            if (this.opts[this.optCur].hasPrev2) {
                this.opts[this.optCur].state.set(this.opts[this.opts[this.optCur].optPrev2].state);
                if (this.opts[this.optCur].backPrev2 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            } else {
                this.opts[this.optCur].state.set(this.opts[n].state);
            }
            this.opts[this.optCur].state.updateLiteral();
        } else {
            this.opts[this.optCur].state.set(this.opts[n].state);
        }
        if (n == this.optCur - 1) {
            assert (this.opts[this.optCur].backPrev == 0 || this.opts[this.optCur].backPrev == -1);
            if (this.opts[this.optCur].backPrev == 0) {
                this.opts[this.optCur].state.updateShortRep();
            } else {
                this.opts[this.optCur].state.updateLiteral();
            }
            System.arraycopy(this.opts[n].reps, 0, this.opts[this.optCur].reps, 0, 4);
        } else {
            int n2;
            if (this.opts[this.optCur].prev1IsLiteral && this.opts[this.optCur].hasPrev2) {
                n = this.opts[this.optCur].optPrev2;
                n2 = this.opts[this.optCur].backPrev2;
                this.opts[this.optCur].state.updateLongRep();
            } else {
                n2 = this.opts[this.optCur].backPrev;
                if (n2 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            }
            if (n2 < 4) {
                int n3;
                this.opts[this.optCur].reps[0] = this.opts[n].reps[n2];
                for (n3 = 1; n3 <= n2; ++n3) {
                    this.opts[this.optCur].reps[n3] = this.opts[n].reps[n3 - 1];
                }
                while (n3 < 4) {
                    this.opts[this.optCur].reps[n3] = this.opts[n].reps[n3];
                    ++n3;
                }
            } else {
                this.opts[this.optCur].reps[0] = n2 - 4;
                System.arraycopy(this.opts[n].reps, 0, this.opts[this.optCur].reps, 1, 3);
            }
        }
    }

    private void calc1BytePrices(int i, int j, int k, int l) {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.lz.getByte(0);
        int n5 = this.opts[this.optCur].price + this.literalEncoder.getPrice(n4, n3 = this.lz.getByte(this.opts[this.optCur].reps[0] + 1), this.lz.getByte(1), i, this.opts[this.optCur].state);
        if (n5 < this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n5, this.optCur, -1);
            bl = true;
        }
        if (n3 == n4 && (this.opts[this.optCur + 1].optPrev == this.optCur || this.opts[this.optCur + 1].backPrev != 0) && (n2 = this.getShortRepPrice(l, this.opts[this.optCur].state, j)) <= this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n2, this.optCur, 0);
            bl = true;
        }
        if (!bl && n3 != n4 && k > 2 && (n = this.lz.getMatchLen(1, this.opts[this.optCur].reps[0], n2 = Math.min(this.niceLen, k - 1))) >= 2) {
            this.nextState.set(this.opts[this.optCur].state);
            this.nextState.updateLiteral();
            int n6 = i + 1 & this.posMask;
            int n7 = n5 + this.getLongRepAndLenPrice(0, n, this.nextState, n6);
            int n8 = this.optCur + 1 + n;
            while (this.optEnd < n8) {
                this.opts[++this.optEnd].reset();
            }
            if (n7 < this.opts[n8].price) {
                this.opts[n8].set2(n7, this.optCur, 0);
            }
        }
    }

    private int calcLongRepPrices(int i, int j, int k, int l) {
        int n = 2;
        int n2 = Math.min(k, this.niceLen);
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3;
            int n4;
            int n5 = this.lz.getMatchLen(this.opts[this.optCur].reps[i2], n2);
            if (n5 < 2) continue;
            while (this.optEnd < this.optCur + n5) {
                this.opts[++this.optEnd].reset();
            }
            int n6 = this.getLongRepPrice(l, i2, this.opts[this.optCur].state, j);
            for (n4 = n5; n4 >= 2; --n4) {
                n3 = n6 + this.repLenEncoder.getPrice(n4, j);
                if (n3 >= this.opts[this.optCur + n4].price) continue;
                this.opts[this.optCur + n4].set1(n3, this.optCur, i2);
            }
            if (i2 == 0) {
                n = n5 + 1;
            }
            if ((n3 = this.lz.getMatchLen(n5 + 1, this.opts[this.optCur].reps[i2], n4 = Math.min(this.niceLen, k - n5 - 1))) < 2) continue;
            int n7 = n6 + this.repLenEncoder.getPrice(n5, j);
            this.nextState.set(this.opts[this.optCur].state);
            this.nextState.updateLongRep();
            int n8 = this.lz.getByte(n5, 0);
            int n9 = this.lz.getByte(0);
            int n10 = this.lz.getByte(n5, 1);
            n7 += this.literalEncoder.getPrice(n8, n9, n10, i + n5, this.nextState);
            this.nextState.updateLiteral();
            int n11 = i + n5 + 1 & this.posMask;
            n7 += this.getLongRepAndLenPrice(0, n3, this.nextState, n11);
            int n12 = this.optCur + n5 + 1 + n3;
            while (this.optEnd < n12) {
                this.opts[++this.optEnd].reset();
            }
            if (n7 >= this.opts[n12].price) continue;
            this.opts[n12].set3(n7, this.optCur, i2, n5, 0);
        }
        return n;
    }

    private void calcNormalMatchPrices(int i, int j, int k, int l, int m) {
        if (this.matches.len[this.matches.count - 1] > k) {
            this.matches.count = 0;
            while (this.matches.len[this.matches.count] < k) {
                ++this.matches.count;
            }
            this.matches.len[this.matches.count++] = k;
        }
        if (this.matches.len[this.matches.count - 1] < m) {
            return;
        }
        while (this.optEnd < this.optCur + this.matches.len[this.matches.count - 1]) {
            this.opts[++this.optEnd].reset();
        }
        int n = this.getNormalMatchPrice(l, this.opts[this.optCur].state);
        int n2 = 0;
        while (m > this.matches.len[n2]) {
            ++n2;
        }
        int n3 = m;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.getMatchAndLenPrice(n, n4 = this.matches.dist[n2], n3, j)) < this.opts[this.optCur + n3].price) {
                this.opts[this.optCur + n3].set1(n5, this.optCur, n4 + 4);
            }
            if (n3 == this.matches.len[n2]) {
                int n6 = Math.min(this.niceLen, k - n3 - 1);
                int n7 = this.lz.getMatchLen(n3 + 1, n4, n6);
                if (n7 >= 2) {
                    this.nextState.set(this.opts[this.optCur].state);
                    this.nextState.updateMatch();
                    int n8 = this.lz.getByte(n3, 0);
                    int n9 = this.lz.getByte(0);
                    int n10 = this.lz.getByte(n3, 1);
                    int n11 = n5 + this.literalEncoder.getPrice(n8, n9, n10, i + n3, this.nextState);
                    this.nextState.updateLiteral();
                    int n12 = i + n3 + 1 & this.posMask;
                    n11 += this.getLongRepAndLenPrice(0, n7, this.nextState, n12);
                    int n13 = this.optCur + n3 + 1 + n7;
                    while (this.optEnd < n13) {
                        this.opts[++this.optEnd].reset();
                    }
                    if (n11 < this.opts[n13].price) {
                        this.opts[n13].set3(n11, this.optCur, n4 + 4, n3, 0);
                    }
                }
                if (++n2 == this.matches.count) break;
            }
            ++n3;
        }
    }
}

