/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ParticleBuilder
implements Cloneable {
    private Particle particle;
    private @Nullable List<Player> receivers;
    private @Nullable Player source;
    private @Nullable Location location;
    private int count = 1;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private double extra = 1.0;
    private @Nullable Object data;
    private boolean force = true;

    public ParticleBuilder(Particle particle) {
        this.particle = particle;
    }

    public ParticleBuilder spawn() {
        if (this.location == null) {
            throw new IllegalStateException("Please specify location for this particle");
        }
        this.location.getWorld().spawnParticle(this.particle, this.receivers, this.source, this.location.getX(), this.location.getY(), this.location.getZ(), this.count, this.offsetX, this.offsetY, this.offsetZ, this.extra, this.data, this.force);
        return this;
    }

    public Particle particle() {
        return this.particle;
    }

    public ParticleBuilder particle(Particle particle) {
        this.particle = particle;
        return this;
    }

    public @Nullable List<Player> receivers() {
        return this.receivers;
    }

    public boolean hasReceivers() {
        return this.receivers == null && this.location != null && !this.location.getWorld().getPlayers().isEmpty() || this.receivers != null && !this.receivers.isEmpty();
    }

    public ParticleBuilder allPlayers() {
        this.receivers = null;
        return this;
    }

    public ParticleBuilder receivers(@Nullable List<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(@Nullable Collection<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(Player ... receivers) {
        this.receivers = receivers != null ? Lists.newArrayList((Object[])receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(int radius) {
        return this.receivers(radius, radius);
    }

    public ParticleBuilder receivers(int radius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(radius, radius, radius);
        }
        if (this.location == null) {
            throw new IllegalStateException("Please set location first");
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)radius, (double)radius, radius)) {
            double z;
            double y;
            Location loc = nearbyPlayer.getLocation();
            double x = NumberConversions.square(this.location.getX() - loc.getX());
            if (Math.sqrt(x + (y = NumberConversions.square(this.location.getY() - loc.getY())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ()))) > (double)radius) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    public ParticleBuilder receivers(int xzRadius, int yRadius) {
        return this.receivers(xzRadius, yRadius, xzRadius);
    }

    public ParticleBuilder receivers(int xzRadius, int yRadius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(xzRadius, yRadius, xzRadius);
        }
        if (this.location == null) {
            throw new IllegalStateException("Please set location first");
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)xzRadius, (double)yRadius, xzRadius)) {
            double z;
            double x;
            Location loc = nearbyPlayer.getLocation();
            if (Math.abs(loc.getY() - this.location.getY()) > (double)yRadius || (x = NumberConversions.square(this.location.getX() - loc.getX())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ())) > NumberConversions.square(xzRadius)) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    public ParticleBuilder receivers(int xRadius, int yRadius, int zRadius) {
        if (this.location == null) {
            throw new IllegalStateException("Please set location first");
        }
        return this.receivers(this.location.getWorld().getNearbyPlayers(this.location, (double)xRadius, (double)yRadius, zRadius));
    }

    public @Nullable Player source() {
        return this.source;
    }

    public ParticleBuilder source(@Nullable Player source) {
        this.source = source;
        return this;
    }

    public @Nullable Location location() {
        return this.location;
    }

    public ParticleBuilder location(Location location) {
        this.location = location.clone();
        return this;
    }

    public ParticleBuilder location(World world, double x, double y, double z) {
        this.location = new Location(world, x, y, z);
        return this;
    }

    public int count() {
        return this.count;
    }

    public ParticleBuilder count(int count) {
        this.count = count;
        return this;
    }

    public double offsetX() {
        return this.offsetX;
    }

    public double offsetY() {
        return this.offsetY;
    }

    public double offsetZ() {
        return this.offsetZ;
    }

    public ParticleBuilder offset(double offsetX, double offsetY, double offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        return this;
    }

    public double extra() {
        return this.extra;
    }

    public ParticleBuilder extra(double extra) {
        this.extra = extra;
        return this;
    }

    public <T> @Nullable T data() {
        return (T)this.data;
    }

    public <T> ParticleBuilder data(@Nullable T data) {
        this.data = data;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public ParticleBuilder force(boolean force) {
        this.force = force;
        return this;
    }

    public ParticleBuilder color(@Nullable Color color) {
        if (this.particle.getDataType() == Color.class) {
            return this.data(color);
        }
        return this.color(color, 1.0f);
    }

    public ParticleBuilder color(@Nullable Color color, float size) {
        if (this.particle.getDataType() != Particle.DustOptions.class && color != null) {
            throw new IllegalStateException("The combination of Color and size cannot be set on this particle type.");
        }
        if (color == null) {
            if (this.data instanceof Particle.DustOptions) {
                return this.data(null);
            }
            return this;
        }
        return this.data(new Particle.DustOptions(color, size));
    }

    public ParticleBuilder color(int r, int g, int b) {
        return this.color(Color.fromRGB(r, g, b));
    }

    public ParticleBuilder color(int color) {
        int alpha = color >> 24 & 0xFF;
        if (alpha == 0) {
            return this.color(Color.fromRGB(color));
        }
        return this.color(Color.fromARGB(color));
    }

    public ParticleBuilder color(int a, int r, int g, int b) {
        return this.color(Color.fromARGB(a, r, g, b));
    }

    public ParticleBuilder colorTransition(Color fromColor, Color toColor) {
        return this.colorTransition(fromColor, toColor, 1.0f);
    }

    public ParticleBuilder colorTransition(int fromRed, int fromGreen, int fromBlue, int toRed, int toGreen, int toBlue) {
        return this.colorTransition(Color.fromRGB(fromRed, fromGreen, fromBlue), Color.fromRGB(toRed, toGreen, toBlue));
    }

    public ParticleBuilder colorTransition(int fromRgb, int toRgb) {
        return this.colorTransition(Color.fromRGB(fromRgb), Color.fromRGB(toRgb));
    }

    public ParticleBuilder colorTransition(Color fromColor, Color toColor, float size) {
        Preconditions.checkArgument((fromColor != null ? 1 : 0) != 0, (Object)"Cannot define color transition with null fromColor.");
        Preconditions.checkArgument((toColor != null ? 1 : 0) != 0, (Object)"Cannot define color transition with null toColor.");
        Preconditions.checkArgument((this.particle() == Particle.DUST_COLOR_TRANSITION ? 1 : 0) != 0, (Object)"Can only define a color transition on particle DUST_COLOR_TRANSITION.");
        return this.data(new Particle.DustTransition(fromColor, toColor, size));
    }

    public ParticleBuilder clone() {
        try {
            ParticleBuilder builder = (ParticleBuilder)super.clone();
            if (this.location != null) {
                builder.location = this.location.clone();
            }
            if (this.receivers != null) {
                builder.receivers = new ObjectArrayList(this.receivers);
            }
            return builder;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

