/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface DialogBase {
    @Contract(value="_, _, _, _, _, _, _ -> new", pure=true)
    public static DialogBase create(Component title, @Nullable Component externalTitle, boolean canCloseWithEscape, boolean pause, DialogAfterAction afterAction, List<? extends DialogBody> body, List<? extends DialogInput> inputs) {
        return DialogBase.builder(title).externalTitle(externalTitle).canCloseWithEscape(canCloseWithEscape).pause(pause).afterAction(afterAction).body(body).inputs(inputs).build();
    }

    @Contract(value="_ -> new", pure=true)
    public static Builder builder(Component title) {
        return DialogInstancesProvider.instance().dialogBaseBuilder(title);
    }

    @Contract(pure=true)
    public Component title();

    @Contract(pure=true)
    public @Nullable Component externalTitle();

    @Contract(pure=true)
    public boolean canCloseWithEscape();

    @Contract(pure=true)
    public boolean pause();

    @Contract(pure=true)
    public DialogAfterAction afterAction();

    @Contract(pure=true)
    public @Unmodifiable List<DialogBody> body();

    @Contract(pure=true)
    public @Unmodifiable List<DialogInput> inputs();

    @ApiStatus.NonExtendable
    public static interface Builder {
        @Contract(value="_ -> this", mutates="this")
        public Builder externalTitle(@Nullable Component var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder canCloseWithEscape(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder pause(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder afterAction(DialogAfterAction var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder body(List<? extends DialogBody> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder inputs(List<? extends DialogInput> var1);

        @Contract(pure=true, value="-> new")
        public DialogBase build();
    }

    public static enum DialogAfterAction {
        CLOSE("close"),
        NONE("none"),
        WAIT_FOR_RESPONSE("wait_for_response");

        public static final Index<String, DialogAfterAction> NAMES;
        private final String name;

        private DialogAfterAction(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(DialogAfterAction.class, e -> e.name);
        }
    }
}

