/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.inventory;

import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class FurnaceBurnEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final ItemStack fuel;
    private int burnTime;
    private boolean burning = true;
    private boolean consumeFuel = true;
    private boolean cancelled;

    @ApiStatus.Internal
    public FurnaceBurnEvent(@NotNull Block furnace, @NotNull ItemStack fuel, int burnTime) {
        super(furnace);
        this.fuel = fuel;
        this.burnTime = burnTime;
    }

    @NotNull
    public ItemStack getFuel() {
        return this.fuel;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(@Range(from=-32768L, to=32767L) int burnTime) {
        this.burnTime = Math.clamp((long)burnTime, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public boolean willConsumeFuel() {
        return this.consumeFuel;
    }

    public void setConsumeFuel(boolean consumeFuel) {
        this.consumeFuel = consumeFuel;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

