/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.widget;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;
import org.joml.Vector4i;

@Environment(value=EnvType.CLIENT)
public class ElementWidget
extends AbstractSimiWidget {
    protected RenderElement element = AbstractRenderElement.EMPTY;
    protected boolean usesFade = false;
    protected int fadeModX;
    protected int fadeModY;
    protected LerpedFloat fade = LerpedFloat.linear().startWithValue(1.0);
    protected boolean rescaleElement = false;
    protected float rescaleSizeX;
    protected float rescaleSizeY;
    protected float paddingX = 0.0f;
    protected float paddingY = 0.0f;
    protected Vector4i scissor;

    public ElementWidget(int x, int y) {
        super(x, y);
    }

    public ElementWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public <T extends ElementWidget> T showingElement(RenderElement element) {
        this.element = element;
        return (T)this;
    }

    public <T extends ElementWidget> T showing(ScreenElement renderable) {
        return this.showingElement(RenderElement.of(renderable));
    }

    public <T extends ElementWidget> T modifyElement(Consumer<RenderElement> consumer) {
        consumer.accept(this.element);
        return (T)this;
    }

    public <T extends ElementWidget> T mapElement(UnaryOperator<RenderElement> function) {
        this.element = (RenderElement)function.apply(this.element);
        return (T)this;
    }

    public <T extends ElementWidget> T withScissor(int x1, int y1, int width, int height) {
        this.scissor = new Vector4i(x1, y1, x1 + width, y1 + height);
        return (T)this;
    }

    public <T extends ElementWidget> T withPadding(float paddingX, float paddingY) {
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        return (T)this;
    }

    public <T extends ElementWidget> T enableFade(int fadeModifierX, int fadeModifierY) {
        this.fade.startWithValue(0.0);
        this.usesFade = true;
        this.fadeModX = fadeModifierX;
        this.fadeModY = fadeModifierY;
        return (T)this;
    }

    public <T extends ElementWidget> T disableFade() {
        this.fade.startWithValue(1.0);
        this.usesFade = false;
        return (T)this;
    }

    public LerpedFloat fade() {
        return this.fade;
    }

    public <T extends ElementWidget> T fade(float target) {
        this.fade.chase(target, 0.1, LerpedFloat.Chaser.EXP);
        return (T)this;
    }

    @Deprecated
    public <T extends ElementWidget> T rescaleElement(float rescaleSizeX, float rescaleSizeY) {
        this.rescaleElement = true;
        this.rescaleSizeX = rescaleSizeX;
        this.rescaleSizeY = rescaleSizeY;
        return (T)this;
    }

    public <T extends ElementWidget> T disableRescale() {
        this.rescaleElement = false;
        return (T)this;
    }

    @Override
    public void tick() {
        super.tick();
        this.fade.tickChaser();
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        this.field_22762 = this.method_25405(mouseX, mouseY);
        float fadeValue = this.fade.getValue(partialTicks);
        this.element.withAlpha(fadeValue);
        if (fadeValue < 1.0f) {
            graphics.method_51448().translate((1.0f - fadeValue) * (float)this.fadeModX, (1.0f - fadeValue) * (float)this.fadeModY);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)this.method_46426() + this.paddingX, (float)this.method_46427() + this.paddingY);
        float innerWidth = (float)this.field_22758 - 2.0f * this.paddingX;
        float innerHeight = (float)this.field_22759 - 2.0f * this.paddingY;
        float eX = this.element.getX();
        float eY = this.element.getY();
        if (this.rescaleElement) {
            float xScale = innerWidth / this.rescaleSizeX;
            float yScale = innerHeight / this.rescaleSizeY;
            poseStack.scale(xScale, yScale);
            this.element.at(eX / xScale, eY / yScale);
            innerWidth /= xScale;
            innerHeight /= yScale;
        }
        if (this.scissor != null) {
            graphics.method_44379(this.scissor.x, this.scissor.y, this.scissor.z, this.scissor.w);
        }
        this.element.withBounds((int)innerWidth, (int)innerHeight).render(graphics);
        if (this.scissor != null) {
            graphics.method_44380();
        }
        poseStack.popMatrix();
        if (this.rescaleElement) {
            this.element.at(eX, eY);
        }
    }

    public RenderElement getRenderElement() {
        return this.element;
    }
}

