/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.OrientedRotatingVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BearingVisual<B extends KineticBlockEntity>
extends OrientedRotatingVisual<B>
implements SimpleDynamicVisual {
    final OrientedInstance topInstance;
    final class_7833 rotationAxis;
    final Quaternionf blockOrientation;

    public BearingVisual(VisualizationContext context, B blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, class_2350.field_11035, ((class_2350)blockEntity.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10153(), Models.partial(AllPartialModels.SHAFT_HALF));
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12525);
        this.rotationAxis = class_7833.method_46356((Vector3f)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.rotationAxis()).method_23955());
        this.blockOrientation = BearingVisual.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(top)).createInstance();
        this.topInstance.position((class_2382)this.getVisualPosition()).rotation((Quaternionfc)this.blockOrientation).setChanged();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float interpolatedAngle = ((IBearingBlockEntity)((Object)((KineticBlockEntity)this.blockEntity))).getInterpolatedAngle(ctx.partialTick() - 1.0f);
        Quaternionf rot = this.rotationAxis.rotationDegrees(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.rotation((Quaternionfc)rot).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.topInstance);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(class_2350 facing) {
        Quaternionf orientation = facing.method_10166().method_10179() ? class_7833.field_40716.rotationDegrees(AngleHelper.horizontalAngle(facing.method_10153())) : new Quaternionf();
        orientation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.topInstance);
    }
}

