/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.zapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.zapper.ConfigureZapperPacket;
import com.zurrtum.create.infrastructure.component.PlacementPatterns;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public abstract class ZapperScreen
extends AbstractSimiScreen {
    protected final class_2561 patternSection = CreateLang.translateDirect("gui.terrainzapper.patternSection", new Object[0]);
    protected AllGuiTextures background;
    protected class_1799 zapper;
    protected class_1268 hand;
    protected float animationProgress;
    protected ElementWidget renderedItem;
    protected ElementWidget renderedBlock;
    protected class_2561 title;
    protected List<IconButton> patternButtons = new ArrayList<IconButton>(6);
    private IconButton confirmButton;
    protected int brightColor;
    protected int fontColor;
    protected PlacementPatterns currentPattern;

    public ZapperScreen(AllGuiTextures background, class_1799 zapper, class_1268 hand) {
        this.background = background;
        this.zapper = zapper;
        this.hand = hand;
        this.title = class_5244.field_39003;
        this.brightColor = 0xFEFEFE;
        this.fontColor = -11051142;
        this.currentPattern = (PlacementPatterns)((Object)zapper.method_58695(AllDataComponents.PLACEMENT_PATTERN, (Object)PlacementPatterns.Solid));
    }

    public AllIcons getIcon(PlacementPatterns pattern) {
        return switch (pattern) {
            default -> throw new MatchException(null, null);
            case PlacementPatterns.Solid -> AllIcons.I_PATTERN_SOLID;
            case PlacementPatterns.Checkered -> AllIcons.I_PATTERN_CHECKERED;
            case PlacementPatterns.InverseCheckered -> AllIcons.I_PATTERN_CHECKERED_INVERSED;
            case PlacementPatterns.Chance25 -> AllIcons.I_PATTERN_CHANCE_25;
            case PlacementPatterns.Chance50 -> AllIcons.I_PATTERN_CHANCE_50;
            case PlacementPatterns.Chance75 -> AllIcons.I_PATTERN_CHANCE_75;
        };
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-10, 0);
        super.method_25426();
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::method_25419);
        this.method_37063(this.confirmButton);
        this.patternButtons.clear();
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + this.background.getWidth() - 76 + col * 18, y + 21 + row * 18, this.getIcon(pattern));
                patternButton.withCallback(() -> {
                    this.patternButtons.forEach(b -> {
                        b.green = false;
                    });
                    patternButton.green = true;
                    this.currentPattern = pattern;
                });
                patternButton.setToolTip((class_2561)CreateLang.translateDirect("gui.terrainzapper.pattern." + pattern.translationKey, new Object[0]));
                this.patternButtons.add(patternButton);
            }
        }
        this.patternButtons.get((int)this.currentPattern.ordinal()).green = true;
        this.addRenderableWidgets(this.patternButtons);
        this.renderedItem = new ElementWidget(x + this.background.getWidth(), y + this.background.getHeight() - 48).showingElement(GuiGameElement.of(this.zapper).scale(4.0f));
        this.method_37063(this.renderedItem);
        this.renderedBlock = new ElementWidget(x + 17, y + 24).showingElement(GuiGameElement.of((class_2680)this.zapper.method_58695(AllDataComponents.SHAPER_BLOCK_USED, (Object)class_2246.field_10124.method_9564())).scale(1.25f).rotate(-25.0f, -45.0f, 0.0f).padding(10));
        this.method_37063(this.renderedBlock);
    }

    public void method_25419() {
        super.method_25419();
        this.renderedItem.getRenderElement().clear();
        this.renderedBlock.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.drawOnBackground(graphics, x, y);
    }

    protected void drawOnBackground(class_332 graphics, int x, int y) {
        graphics.method_51439(this.field_22793, this.title, x + (this.background.getWidth() - this.field_22793.method_27525((class_5348)this.title)) / 2, y + 4, -11263665, false);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.animationProgress += 5.0f;
    }

    public void method_25432() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        this.field_22787.field_1724.field_3944.method_52787((class_2596)packet);
    }

    protected abstract ConfigureZapperPacket getConfigurationPacket();
}

