/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gauge;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GaugeRenderer
extends ShaftRenderer<GaugeBlockEntity, GaugeRenderState> {
    protected GaugeBlock.Type type;

    public static GaugeRenderer speed(class_5614.class_5615 context) {
        return new GaugeRenderer(context, GaugeBlock.Type.SPEED);
    }

    public static GaugeRenderer stress(class_5614.class_5615 context) {
        return new GaugeRenderer(context, GaugeBlock.Type.STRESS);
    }

    protected GaugeRenderer(class_5614.class_5615 context, GaugeBlock.Type type) {
        super(context);
        this.type = type;
    }

    @Override
    public GaugeRenderState createRenderState() {
        return new GaugeRenderState();
    }

    @Override
    public void updateRenderState(GaugeBlockEntity be, GaugeRenderState state, float tickProgress, class_243 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 crumblingOverlay) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        class_2680 gaugeState = be.method_11010();
        GaugeBlock block = (GaugeBlock)gaugeState.method_26204();
        class_1937 world = be.method_10997();
        ArrayList<class_2350> facings = new ArrayList<class_2350>();
        for (class_2350 facing : Iterate.directions) {
            if (!block.shouldRenderHeadOnFace(world, state.field_62673, gaugeState, facing)) continue;
            facings.add(facing);
        }
        if (facings.isEmpty()) {
            return;
        }
        int size = facings.size();
        float[] angles = new float[size];
        for (int i = 0; i < size; ++i) {
            angles[i] = (float)((double)((-((class_2350)facings.get(i)).method_10144() - 90.0f) / 180.0f) * Math.PI);
        }
        state.angles = angles;
        PartialModel partialModel = this.type == GaugeBlock.Type.SPEED ? AllPartialModels.GAUGE_HEAD_SPEED : AllPartialModels.GAUGE_HEAD_STRESS;
        state.head = CachedBuffers.partial(partialModel, gaugeState);
        state.dial = CachedBuffers.partial(AllPartialModels.GAUGE_DIAL, gaugeState);
        state.dialPivot = 0.359375f;
        float progress = class_3532.method_16439((float)tickProgress, (float)be.prevDialState, (float)be.dialState);
        state.rotate = (float)(1.5707963267948966 * (double)(-progress));
    }

    @Environment(value=EnvType.CLIENT)
    public static class GaugeRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float[] angles;
        public SuperByteBuffer head;
        public SuperByteBuffer dial;
        public float dialPivot;
        public float rotate;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (this.angles != null) {
                for (float angle : this.angles) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.dial.rotateCentered(angle, class_2350.field_11036)).translate(0.0f, this.dialPivot, this.dialPivot)).rotate(this.rotate, class_2350.field_11034)).translate(0.0f, -this.dialPivot, -this.dialPivot)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
                    ((SuperByteBuffer)this.head.rotateCentered(angle, class_2350.field_11036)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}

