/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FactoryPanelRenderer
extends SmartBlockEntityRenderer<FactoryPanelBlockEntity, FactoryPanelRenderState> {
    public FactoryPanelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public FactoryPanelRenderState createRenderState() {
        return new FactoryPanelRenderState();
    }

    @Override
    public void updateRenderState(FactoryPanelBlockEntity be, FactoryPanelRenderState state, float tickProgress, class_243 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 crumblingOverlay) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        ArrayList<SingleFactoryPanelRenderState> panels = new ArrayList<SingleFactoryPanelRenderState>();
        boolean[] layers = new boolean[3];
        for (ServerFactoryPanelBehaviour behaviour : be.panels.values()) {
            boolean target;
            if (!behaviour.isActive()) continue;
            boolean bulb = behaviour.getAmount() > 0;
            boolean bl = target = !behaviour.targetedBy.isEmpty() || !behaviour.targetedByLinks.isEmpty();
            if (!target && !bulb) continue;
            SingleFactoryPanelRenderState panel = new SingleFactoryPanelRenderState();
            boolean missingAddress = behaviour.isMissingAddress();
            float offsetX = (float)behaviour.slot.xOffset * 0.5f;
            float offsetY = (float)behaviour.slot.yOffset * 0.5f;
            float glow = behaviour.bulb.getValue(tickProgress);
            if (target) {
                List<class_2350> path;
                layers[0] = true;
                panel.offsetX = offsetX + 0.25f;
                panel.offsetY = offsetY + 0.25f;
                panel.paths = new ArrayList<PathRenderState>();
                ArrayList<PathRenderState> paths = panel.paths;
                class_1937 world = behaviour.getWorld();
                FactoryPanelPosition to = behaviour.getPanelPosition();
                FactoryPanelBehaviour fromBehaviour = be.getBehaviour(FactoryPanelBehaviour.getTypeForSlot(behaviour.slot));
                class_243 start = fromBehaviour.getSlotPositioning().getLocalOffset(state.field_62674).method_1019(class_243.method_24954((class_2382)state.field_62673));
                for (FactoryPanelConnection connection : behaviour.targetedBy.values()) {
                    path = connection.getPath(world, state.field_62674, to, start);
                    if (path.isEmpty()) continue;
                    paths.add(FactoryPanelRenderer.getPathRenderState(behaviour, connection, path, world, state.field_62674, missingAddress, glow));
                }
                for (FactoryPanelConnection connection : behaviour.targetedByLinks.values()) {
                    path = connection.getPath(world, state.field_62674, to, start);
                    if (path.isEmpty()) continue;
                    paths.add(FactoryPanelRenderer.getPathRenderState(behaviour, connection, path, world, state.field_62674, missingAddress, glow));
                }
            }
            if (bulb) {
                panel.bulb = FactoryPanelRenderer.getBulbRenderState(behaviour, state.field_62674, missingAddress, offsetX, offsetY, glow, layers);
            }
            panels.add(panel);
        }
        if (panels.isEmpty()) {
            return;
        }
        state.xRot = FactoryPanelBlock.getXRot(state.field_62674) + 1.5707964f;
        state.yRot = FactoryPanelBlock.getYRot(state.field_62674);
        state.panels = panels;
        if (layers[0]) {
            state.cutout = class_1921.method_23579();
        }
        if (layers[1]) {
            state.translucent1 = PonderRenderTypes.translucent();
        }
        if (layers[2]) {
            state.translucent2 = RenderTypes.translucent();
            state.additive = RenderTypes.additive();
        }
    }

    @Override
    public void render(FactoryPanelRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.panels != null) {
            if (state.cutout != null) {
                queue.method_73483(matrices, state.cutout, state::renderCutout);
            }
            if (state.translucent1 != null) {
                queue.method_73483(matrices, state.translucent1, state::renderTranslucent1);
            }
            if (state.additive != null) {
                queue.method_73483(matrices, state.translucent2, state::renderTranslucent2);
                queue.method_73483(matrices, state.additive, state::renderAdditive);
            }
        }
    }

    public static BulbRenderState getBulbRenderState(ServerFactoryPanelBehaviour behaviour, class_2680 blockState, boolean missingAddress, float offsetX, float offsetY, float glow, boolean[] layers) {
        BulbRenderState state = new BulbRenderState();
        PartialModel partial = behaviour.redstonePowered || missingAddress ? AllPartialModels.FACTORY_PANEL_RED_LIGHT : AllPartialModels.FACTORY_PANEL_LIGHT;
        state.model = CachedBuffers.partial(partial, blockState);
        state.offsetX = offsetX;
        state.offsetY = offsetY;
        if (glow < 0.125f) {
            layers[1] = true;
            return state;
        }
        layers[2] = true;
        state.glow = true;
        glow = (float)(1.0 - 2.0 * Math.pow(glow - 0.75f, 2.0));
        glow = class_3532.method_15363((float)glow, (float)-1.0f, (float)1.0f);
        state.color = (int)(200.0f * glow);
        return state;
    }

    public static PathRenderState getPathRenderState(ServerFactoryPanelBehaviour behaviour, FactoryPanelConnection connection, List<class_2350> path, class_1937 world, class_2680 blockState, boolean missingAddress, float glow) {
        float yOffset;
        boolean dots;
        int color;
        boolean pathReversed;
        PathRenderState state = new PathRenderState();
        FactoryPanelSupportBehaviour sbe = ServerFactoryPanelBehaviour.linkAt((class_1920)world, connection);
        boolean displayLinkMode = sbe != null && sbe.blockEntity instanceof DisplayLinkBlockEntity;
        boolean redstoneLinkMode = sbe != null && sbe.blockEntity instanceof RedstoneLinkBlockEntity;
        boolean bl = pathReversed = sbe != null && !sbe.isOutput();
        if (displayLinkMode) {
            color = 3971154;
            dots = true;
            yOffset = 0.0f;
        } else if (redstoneLinkMode) {
            color = pathReversed ? (behaviour.count == 0 ? 0x888898 : (behaviour.satisfied ? 0xEF0000 : 5767425)) : (behaviour.redstonePowered ? 0xEF0000 : 5767425);
            dots = false;
            yOffset = 0.5f;
        } else {
            color = behaviour.getIngredientStatusColor();
            dots = false;
            yOffset = 1 + (behaviour.promisedSatisfied ? 1 : (behaviour.satisfied ? 0 : 2));
            if (!behaviour.redstonePowered && !behaviour.waitingForNetwork && glow > 0.0f && !behaviour.satisfied) {
                float p = 1.0f - (1.0f - glow) * (1.0f - glow);
                boolean success = connection.success;
                color = Color.mixColors(color, success ? 15397612 : 15033675, p);
                if (!behaviour.promisedSatisfied) {
                    yOffset += (float)(success ? 1 : 2) * p;
                }
            }
        }
        state.shiftUV = !displayLinkMode && !redstoneLinkMode && !missingAddress && !behaviour.waitingForNetwork && !behaviour.satisfied && !behaviour.redstonePowered;
        state.color = color;
        float currentX = 0.0f;
        float currentZ = 0.0f;
        state.lines = new ArrayList<LineRenderData>();
        ArrayList<LineRenderData> lines = state.lines;
        int size = path.size();
        int end = size - 1;
        for (int i = 0; i < size; ++i) {
            class_2350 direction = path.get(i);
            if (!pathReversed) {
                currentX += (float)direction.method_10148() * 0.5f;
                currentZ += (float)direction.method_10165() * 0.5f;
            }
            Map<class_2350, PartialModel> group = dots ? AllPartialModels.FACTORY_PANEL_DOTTED : ((pathReversed ? i == end : i == 0) ? AllPartialModels.FACTORY_PANEL_ARROWS : AllPartialModels.FACTORY_PANEL_LINES);
            PartialModel partial = group.get(pathReversed ? direction : direction.method_10153());
            SuperByteBuffer model = CachedBuffers.partial(partial, blockState);
            float currentY = (yOffset + (float)(direction.method_10161() % 2) * 0.125f) / 512.0f;
            lines.add(new LineRenderData(model, currentX, currentY, currentZ));
            if (!pathReversed) continue;
            currentX += (float)direction.method_10148() * 0.5f;
            currentZ += (float)direction.method_10165() * 0.5f;
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FactoryPanelRenderState
    extends SmartBlockEntityRenderer.SmartRenderState {
        public class_1921 cutout;
        public class_1921 translucent1;
        public class_1921 translucent2;
        public class_1921 additive;
        public float xRot;
        public float yRot;
        public List<SingleFactoryPanelRenderState> panels;

        public void renderCutout(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderPaths(matricesEntry, vertexConsumer, this.xRot, this.yRot, this.field_62676);
            }
        }

        public void renderTranslucent1(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderBulb(false, matricesEntry, vertexConsumer, this.xRot, this.yRot, this.field_62676);
            }
        }

        public void renderTranslucent2(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderBulb(true, matricesEntry, vertexConsumer, this.xRot, this.yRot, this.field_62676);
            }
        }

        public void renderAdditive(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderGlow(matricesEntry, vertexConsumer, this.xRot, this.yRot);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SingleFactoryPanelRenderState {
        public float offsetX;
        public float offsetY;
        public List<PathRenderState> paths;
        public BulbRenderState bulb;

        public void renderPaths(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (this.paths != null) {
                for (PathRenderState path : this.paths) {
                    path.render(matricesEntry, vertexConsumer, xRot, yRot, this.offsetX, this.offsetY, light);
                }
            }
        }

        public void renderBulb(boolean glow, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (this.bulb != null) {
                this.bulb.renderBulb(glow, matricesEntry, vertexConsumer, xRot, yRot, light);
            }
        }

        public void renderGlow(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot) {
            if (this.bulb != null) {
                this.bulb.renderGlow(matricesEntry, vertexConsumer, xRot, yRot);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PathRenderState {
        public boolean shiftUV;
        public int color;
        public List<LineRenderData> lines;

        public void render(class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot, float offsetX, float offsetY, int light) {
            for (LineRenderData line : this.lines) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)line.model.rotateCentered(yRot, class_2350.field_11036)).rotateCentered(xRot, class_2350.field_11034)).rotateCentered((float)Math.PI, class_2350.field_11036)).translate(offsetX, 0.0f, offsetY)).translate(line.x, line.y, line.z);
                if (this.shiftUV) {
                    line.model.shiftUV(AllSpriteShifts.FACTORY_PANEL_CONNECTIONS);
                }
                line.model.color(this.color).light(light).overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BulbRenderState {
        public SuperByteBuffer model;
        public float offsetX;
        public float offsetY;
        public boolean glow;
        public int color;

        public void renderBulb(boolean glow, class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (glow == this.glow) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateCentered(yRot, class_2350.field_11036)).rotateCentered(xRot, class_2350.field_11034)).rotateCentered((float)Math.PI, class_2350.field_11036)).translate(this.offsetX, 0.0f, this.offsetY)).light(glow ? 0xF000F0 : light).overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }

        private void renderGlow(class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot) {
            if (this.glow) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateCentered(yRot, class_2350.field_11036)).rotateCentered(xRot, class_2350.field_11034)).rotateCentered((float)Math.PI, class_2350.field_11036)).translate(this.offsetX, 0.0f, this.offsetY)).light(0xF000F0).color(this.color, this.color, this.color, 255).overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record LineRenderData(SuperByteBuffer model, float x, float y, float z) {
    }
}

