/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class BakedModelHelper {
    public static int[] cropAndMove(int[] vertexData, class_1058 sprite, class_238 crop, class_243 move) {
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        class_243 xyz0 = BakedQuadHelper.getXYZ(vertexData, 0);
        class_243 xyz1 = BakedQuadHelper.getXYZ(vertexData, 1);
        class_243 xyz2 = BakedQuadHelper.getXYZ(vertexData, 2);
        class_243 xyz3 = BakedQuadHelper.getXYZ(vertexData, 3);
        class_243 uAxis = xyz3.method_1019(xyz2).method_1021(0.5);
        class_243 vAxis = xyz1.method_1019(xyz2).method_1021(0.5);
        class_243 center = xyz3.method_1019(xyz2).method_1019(xyz0).method_1019(xyz1).method_1021(0.25);
        float u0 = BakedQuadHelper.getU(vertexData, 0);
        float u3 = BakedQuadHelper.getU(vertexData, 3);
        float v0 = BakedQuadHelper.getV(vertexData, 0);
        float v1 = BakedQuadHelper.getV(vertexData, 1);
        float uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u3) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz3.method_1022(xyz0));
        float vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v1) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz1.method_1022(xyz0));
        if (uScale == 0.0f) {
            float v3 = BakedQuadHelper.getV(vertexData, 3);
            float u1 = BakedQuadHelper.getU(vertexData, 1);
            uAxis = xyz1.method_1019(xyz2).method_1021(0.5);
            vAxis = xyz3.method_1019(xyz2).method_1021(0.5);
            uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u1) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz1.method_1022(xyz0));
            vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v3) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz3.method_1022(xyz0));
        }
        uAxis = uAxis.method_1020(center).method_1029();
        vAxis = vAxis.method_1020(center).method_1029();
        class_243 min = new class_243(crop.field_1323, crop.field_1322, crop.field_1321);
        class_243 max = new class_243(crop.field_1320, crop.field_1325, crop.field_1324);
        for (int vertex = 0; vertex < 4; ++vertex) {
            class_243 xyz = BakedQuadHelper.getXYZ(vertexData, vertex);
            class_243 newXyz = VecHelper.componentMin(max, VecHelper.componentMax(xyz, min));
            class_243 diff = newXyz.method_1020(xyz);
            if (diff.method_1027() > 0.0) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                float uDiff = (float)uAxis.method_1026(diff) * uScale;
                float vDiff = (float)vAxis.method_1026(diff) * vScale;
                BakedQuadHelper.setU(vertexData, vertex, sprite.method_4580(SpriteShiftEntry.getUnInterpolatedU(sprite, u) + uDiff));
                BakedQuadHelper.setV(vertexData, vertex, sprite.method_4570(SpriteShiftEntry.getUnInterpolatedV(sprite, v) + vDiff));
            }
            BakedQuadHelper.setXYZ(vertexData, vertex, newXyz.method_1019(move));
        }
        return vertexData;
    }

    public static class_10801 generateModel(class_10801 template, UnaryOperator<class_1058> spriteSwapper) {
        class_10817.class_10818 builder = new class_10817.class_10818();
        for (class_2350 cullFace : Iterate.directions) {
            List quads = template.method_68509(cullFace);
            BakedModelHelper.swapSprites(quads, spriteSwapper).forEach(quad -> builder.method_68053(cullFace, quad));
        }
        List quads = template.method_68509(null);
        BakedModelHelper.swapSprites(quads, spriteSwapper).forEach(arg_0 -> ((class_10817.class_10818)builder).method_68051(arg_0));
        class_1058 particleSprite = template.comp_3752();
        class_1058 swappedParticleSprite = (class_1058)spriteSwapper.apply(particleSprite);
        if (swappedParticleSprite != null) {
            particleSprite = swappedParticleSprite;
        }
        return new class_10801(builder.method_68050(), template.comp_3751(), particleSprite);
    }

    public static List<class_777> swapSprites(List<class_777> quads, UnaryOperator<class_1058> spriteSwapper) {
        ArrayList<class_777> newQuads = new ArrayList<class_777>(quads);
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            class_777 quad = quads.get(i);
            class_1058 sprite = quad.comp_3724();
            class_1058 newSprite = (class_1058)spriteSwapper.apply(sprite);
            if (newSprite == null || sprite == newSprite) continue;
            class_777 newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.comp_3721();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, newSprite.method_4580(SpriteShiftEntry.getUnInterpolatedU(sprite, u)));
                BakedQuadHelper.setV(vertexData, vertex, newSprite.method_4570(SpriteShiftEntry.getUnInterpolatedV(sprite, v)));
            }
            newQuads.set(i, newQuad);
        }
        return newQuads;
    }
}

