/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model.obj;

import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.client.model.obj.UnitTextureAtlasSprite;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_4588;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class QuadBakingVertexConsumer
implements class_4588 {
    public static final int STRIDE = class_290.field_1590.getVertexSize() / 4;
    public static final int POSITION = QuadBakingVertexConsumer.findOffset(VertexFormatElement.POSITION);
    public static final int COLOR = QuadBakingVertexConsumer.findOffset(VertexFormatElement.COLOR);
    public static final int UV0 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV0);
    public static final int UV1 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV1);
    public static final int UV2 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV2);
    public static final int NORMAL = QuadBakingVertexConsumer.findOffset(VertexFormatElement.NORMAL);
    private final Map<VertexFormatElement, Integer> ELEMENT_OFFSETS = (Map)class_156.method_654(new IdentityHashMap(), map -> {
        for (VertexFormatElement element : class_290.field_1590.getElements()) {
            map.put(element, class_290.field_1590.getOffset(element) / 4);
        }
    });
    private static final int QUAD_DATA_SIZE = STRIDE * 4;
    private final int[] quadData = new int[QUAD_DATA_SIZE];
    private int vertexIndex = 0;
    private boolean building = false;
    private int tintIndex = -1;
    private class_2350 direction = class_2350.field_11033;
    private class_1058 sprite = UnitTextureAtlasSprite.INSTANCE;
    private boolean shade;
    private int lightEmission;
    private boolean hasAmbientOcclusion;

    private static int findOffset(VertexFormatElement element) {
        if (class_290.field_1590.contains(element)) {
            return class_290.field_1590.getOffset(element) / 4;
        }
        return -1;
    }

    public class_4588 method_22912(float x, float y, float z) {
        if (this.building && ++this.vertexIndex > 4) {
            throw new IllegalStateException("Expected quad export after fourth vertex");
        }
        this.building = true;
        int offset = this.vertexIndex * STRIDE + POSITION;
        this.quadData[offset] = Float.floatToRawIntBits(x);
        this.quadData[offset + 1] = Float.floatToRawIntBits(y);
        this.quadData[offset + 2] = Float.floatToRawIntBits(z);
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        int offset = this.vertexIndex * STRIDE + NORMAL;
        this.quadData[offset] = (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
        return this;
    }

    public class_4588 method_1336(int r, int g, int b, int a) {
        int offset = this.vertexIndex * STRIDE + COLOR;
        this.quadData[offset] = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        int offset = this.vertexIndex * STRIDE + UV0;
        this.quadData[offset] = Float.floatToRawIntBits(u);
        this.quadData[offset + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public class_4588 method_60796(int u, int v) {
        if (UV1 >= 0) {
            int offset = this.vertexIndex * STRIDE + UV1;
            this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        }
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        int offset = this.vertexIndex * STRIDE + UV2;
        this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        return this;
    }

    public class_4588 misc(VertexFormatElement element, int ... rawData) {
        Integer baseOffset = this.ELEMENT_OFFSETS.get(element);
        if (baseOffset != null) {
            int offset = this.vertexIndex * STRIDE + baseOffset;
            System.arraycopy(rawData, 0, this.quadData, offset, rawData.length);
        }
        return this;
    }

    public void setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
    }

    public void setDirection(class_2350 direction) {
        this.direction = direction;
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public class_777 bakeQuad() {
        if (!this.building || ++this.vertexIndex != 4) {
            throw new IllegalStateException("Not enough vertices available. Vertices in buffer: " + this.vertexIndex);
        }
        class_777 quad = new class_777((int[])this.quadData.clone(), this.tintIndex, this.direction, this.sprite, this.shade, this.lightEmission);
        NormalsBakedQuad.markNormals(quad);
        this.vertexIndex = 0;
        this.building = false;
        Arrays.fill(this.quadData, 0);
        return quad;
    }
}

