/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedSceneElementBase;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class HideAllInstruction
extends TickingInstruction {
    private final class_2350 fadeOutTo;

    public HideAllInstruction(int fadeOutTicks, class_2350 fadeOutTo) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.getElements().forEach(element -> {
            if (element instanceof AnimatedSceneElementBase) {
                AnimatedSceneElementBase animatedSceneElement = (AnimatedSceneElementBase)element;
                animatedSceneElement.setFade(1.0f);
                animatedSceneElement.setFadeVec(this.fadeOutTo == null ? null : class_243.method_24954((class_2382)this.fadeOutTo.method_62675()).method_1021(0.5));
            } else if (element instanceof AnimatedOverlayElementBase) {
                AnimatedOverlayElementBase animatedSceneElement = (AnimatedOverlayElementBase)element;
                animatedSceneElement.setFade(1.0f);
            } else {
                element.setVisible(false);
            }
        });
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        scene.forEach(AnimatedSceneElementBase.class, ase -> {
            ase.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                ase.setFade(0.0f);
            }
        });
        scene.forEach(AnimatedOverlayElementBase.class, aoe -> {
            aoe.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                aoe.setFade(0.0f);
            }
        });
    }
}

