/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.rei.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record DrainingDisplay(EntryIngredient input, EntryIngredient output, EntryIngredient result, Optional<class_2960> location) implements Display
{
    public static final class_2960 POTIONS = class_2960.method_60655((String)"create", (String)"potions");
    public static final DisplaySerializer<DrainingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("input").forGetter(DrainingDisplay::input), (App)EntryIngredient.codec().fieldOf("output").forGetter(DrainingDisplay::output), (App)EntryIngredient.codec().fieldOf("result").forGetter(DrainingDisplay::result), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(DrainingDisplay::location)).apply((Applicative)instance, DrainingDisplay::new)), (class_9139)class_9139.method_56905((class_9139)EntryIngredient.streamCodec(), DrainingDisplay::input, (class_9139)EntryIngredient.streamCodec(), DrainingDisplay::output, (class_9139)EntryIngredient.streamCodec(), DrainingDisplay::result, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), DrainingDisplay::location, DrainingDisplay::new));

    public DrainingDisplay(class_8786<EmptyingRecipe> entry) {
        this(entry.comp_1932().method_29177(), (EmptyingRecipe)entry.comp_1933());
    }

    public DrainingDisplay(class_2960 id, EmptyingRecipe recipe) {
        this(EntryIngredients.ofIngredient((class_1856)recipe.ingredient()), IngredientHelper.createEntryIngredient(recipe.fluidResult()), EntryIngredients.of((class_1799)recipe.result()), Optional.of(id));
    }

    public static void register(Stream<EntryStack<?>> itemStream, DisplayConsumer registry) {
        itemStream.forEach(entry -> {
            class_1799 stack = (class_1799)entry.castValue();
            if (PotionFluidHandler.isPotionItem(stack)) {
                registry.add((Display)new DrainingDisplay(EntryIngredients.of((class_1799)stack), IngredientHelper.createEntryIngredient(PotionFluidHandler.getFluidFromPotionItem(stack)), EntryIngredients.of((class_1935)class_1802.field_8469), Optional.of(POTIONS)));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972());){
                if (capability == null) {
                    return;
                }
                FluidStack fluid = capability.extractAny(81000);
                if (fluid.isEmpty()) {
                    return;
                }
                class_2960 itemName = class_7923.field_41178.method_10221((Object)stack.method_7909());
                class_2960 fluidName = class_7923.field_41173.method_10221((Object)fluid.getFluid());
                class_2960 id = class_2960.method_60655((String)"create", (String)("empty_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()));
                registry.add((Display)new DrainingDisplay(EntryIngredients.of((class_1799)stack), IngredientHelper.createEntryIngredient(fluid), EntryIngredients.of((class_1799)capability.getContainer()), Optional.of(id)));
            }
        });
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(this.input);
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(this.output, this.result);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.DRAINING;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

