/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.IControlContraption;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3499;

public class ControlledContraptionEntity
extends AbstractContraptionEntity {
    protected class_2338 controllerPos;
    protected class_2350.class_2351 rotationAxis;
    public float prevAngle;
    public float angle;
    protected float angleDelta;

    public ControlledContraptionEntity(class_1299<? extends ControlledContraptionEntity> type, class_1937 world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(class_1937 world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity((class_1299<? extends ControlledContraptionEntity>)AllEntityTypes.CONTROLLED_CONTRAPTION, world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        if (!this.method_73183().method_8608()) {
            return;
        }
        for (class_1297 entity : this.method_5685()) {
            this.method_24201(entity);
        }
    }

    @Override
    public class_243 getContactPointMotion(class_243 globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.method_18798();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption) {
            this.rotationAxis = ((BearingContraption)contraption).getFacing().method_10166();
        }
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        view.method_71426("ControllerRelative", class_2338.field_25064).ifPresent(pos -> {
            this.controllerPos = pos.method_10081((class_2382)this.method_24515());
        });
        view.method_71426("Axis", (Codec)class_2350.class_2351.field_25065).ifPresent(axis -> {
            this.rotationAxis = axis;
        });
        this.angle = view.method_71423("Angle", 0.0f);
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);
        view.method_71468("ControllerRelative", class_2338.field_25064, (Object)this.controllerPos.method_10059((class_2382)this.method_24515()));
        if (this.rotationAxis != null) {
            view.method_71468("Axis", (Codec)class_2350.class_2351.field_25065, (Object)this.rotationAxis);
        }
        view.method_71464("Angle", this.angle);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        if (this.rotationAxis == class_2350.class_2351.field_11048) {
            crs.xRotation = this.angle;
        }
        if (this.rotationAxis == class_2350.class_2351.field_11052) {
            crs.yRotation = this.angle;
        }
        if (this.rotationAxis == class_2350.class_2351.field_11051) {
            crs.zRotation = this.angle;
        }
        return crs;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        if (!this.method_73183().method_8608()) {
            return;
        }
        for (class_1297 entity : this.method_5685()) {
            this.method_24201(entity);
        }
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0f ? this.angle : AngleHelper.angleLerp(partialTicks, this.prevAngle, this.angle);
    }

    public void setRotationAxis(class_2350.class_2351 rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public class_2350.class_2351 getRotationAxis() {
        return this.rotationAxis;
    }

    public void method_5859(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    @Override
    protected void tickContraption() {
        this.angleDelta = this.angle - this.prevAngle;
        this.prevAngle = this.angle;
        this.tickActors();
        if (this.controllerPos == null) {
            return;
        }
        if (!this.method_73183().method_8477(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.method_31472();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (this.method_73183().method_8608()) {
                this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    @Override
    protected boolean shouldActorTrigger(MovementContext context, class_3499.class_3501 blockInfo, MovementBehaviour actor, class_243 actorPosition, class_2338 gridPosition) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition)) {
            return true;
        }
        Contraption contraption = this.contraption;
        if (!(contraption instanceof BearingContraption)) {
            return false;
        }
        BearingContraption bc = (BearingContraption)contraption;
        class_2350 facing = bc.getFacing();
        class_243 activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.method_18806(VecHelper.axisAlingedPlaneOf(class_243.method_24954((class_2382)facing.method_62675()))).equals((Object)class_243.field_1353)) {
            return false;
        }
        if (!VecHelper.onSameAxis(blockInfo.comp_1341(), class_2338.field_10980, facing.method_10166())) {
            return false;
        }
        context.relativeMotion = context.motion = class_243.method_24954((class_2382)facing.method_62675()).method_1021((double)this.angleDelta / 360.0);
        int timer = context.data.method_68083("StationaryTimer", 0);
        if (timer > 0) {
            context.data.method_10569("StationaryTimer", timer - 1);
            return false;
        }
        context.data.method_10569("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.method_73183().method_8477(this.controllerPos)) {
            return null;
        }
        class_2586 be = this.method_73183().method_8321(this.controllerPos);
        if (!(be instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)be;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = class_2338.method_49638((class_2374)this.getAnchorVec().method_1031(0.5, 0.5, 0.5));
        float xRot = this.rotationAxis == class_2350.class_2351.field_11048 ? this.angle : 0.0f;
        float yRot = this.rotationAxis == class_2350.class_2351.field_11052 ? this.angle : 0.0f;
        float zRot = this.rotationAxis == class_2350.class_2351.field_11051 ? this.angle : 0.0f;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return this.angle;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.method_23327(x, y, z);
        this.angle = this.prevAngle = angle;
    }
}

