/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.ComparatorUtil;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_8824;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9473;

public class BacktankBlockEntity
extends KineticBlockEntity
implements class_1275 {
    public int airLevel;
    public int airLevelTimer;
    private final class_2561 defaultName;
    private class_2561 customName;
    private int capacityEnchantLevel;
    private class_9326 componentPatch;

    public BacktankBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BACKTANK, pos, state);
        this.defaultName = BacktankBlockEntity.getDefaultName(state);
        this.componentPatch = class_9326.field_49588;
    }

    public static class_2561 getDefaultName(class_2680 state) {
        if (state.method_27852((class_2248)AllBlocks.NETHERITE_BACKTANK)) {
            AllItems.NETHERITE_BACKTANK.method_63680();
        }
        return AllItems.COPPER_BACKTANK.method_63680();
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.BACKTANK);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.BACKTANK);
        }
    }

    @Override
    public void tick() {
        class_2746 waterProperty;
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)(waterProperty = class_2741.field_12508)) && ((Boolean)state.method_11654((class_2769)waterProperty)).booleanValue()) {
            return;
        }
        if (this.airLevelTimer > 0) {
            --this.airLevelTimer;
            return;
        }
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        if (this.field_11863.method_8608()) {
            class_243 centerOf = VecHelper.getCenterOf((class_2382)this.field_11867);
            class_243 v = VecHelper.offsetRandomly(centerOf, this.field_11863.field_9229, 0.65f);
            class_243 m = centerOf.method_1020(v);
            if (this.airLevel != max) {
                this.field_11863.method_8406((class_2394)new AirParticleData(1.0f, 0.05f), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
            }
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        int prevComparatorLevel = this.getComparatorOutput();
        float abs = Math.abs(this.getSpeed());
        int increment = class_3532.method_15340((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        if (this.getComparatorOutput() != prevComparatorLevel && !this.field_11863.method_8608()) {
            this.field_11863.method_8455(this.field_11867, state.method_26204());
        }
        if (this.airLevel == max) {
            this.sendData();
        }
        this.airLevelTimer = class_3532.method_15340((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
    }

    public int getComparatorOutput() {
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((float)this.airLevel / (float)max);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("Air", this.airLevel);
        view.method_71465("Timer", this.airLevelTimer);
        view.method_71465("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            view.method_71468("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        view.method_71468("Components", class_9326.field_49589, (Object)this.componentPatch);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        int prev = this.airLevel;
        this.airLevel = view.method_71424("Air", 0);
        this.airLevelTimer = view.method_71424("Timer", 0);
        this.capacityEnchantLevel = view.method_71424("CapacityEnchantment", 0);
        this.customName = view.method_71426("CustomName", class_8824.field_46597).orElse(null);
        this.componentPatch = view.method_71426("Components", class_9326.field_49589).orElse(class_9326.field_49588);
        if (prev != 0 && prev != this.airLevel && this.airLevel == BacktankUtil.maxAir(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void method_57568(class_9473 componentInput) {
        this.setAirLevel((Integer)componentInput.method_58695(AllDataComponents.BACKTANK_AIR, (Object)0));
    }

    protected void method_57567(class_9323.class_9324 components) {
        components.method_57840(AllDataComponents.BACKTANK_AIR, (Object)this.airLevel);
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.field_11863, (class_2382)this.field_11867, 0.4f, 1.0f, true);
        class_243 baseMotion = new class_243(0.25, 0.1, 0.0);
        class_243 baseVec = VecHelper.getCenterOf((class_2382)this.field_11867);
        for (int i = 0; i < 360; i += 10) {
            class_243 m = VecHelper.rotate(baseMotion, i, class_2350.class_2351.field_11052);
            class_243 v = baseVec.method_1019(m.method_1029().method_1021(0.25));
            this.field_11863.method_8406((class_2394)class_2398.field_11228, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public int getAirLevel() {
        return this.airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        this.sendData();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }

    public void setComponentPatch(class_9326 componentPatch) {
        this.componentPatch = componentPatch;
    }

    public class_9326 getComponentPatch() {
        return this.componentPatch;
    }
}

