/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.fluids.tank.BoilerData;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    public FluidInventory fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected FluidTank tankInventory = this.createInventory();
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    public boolean window = true;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    public BoilerData boiler = new BoilerData();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;

    public FluidTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    public static FluidTankBlockEntity tank(class_2338 pos, class_2680 state) {
        return new FluidTankBlockEntity(AllBlockEntityTypes.FLUID_TANK, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        this.field_11863.method_8544(pos);
        ConnectivityHandler.splitMulti(this);
    }

    protected FluidTank createInventory() {
        return new FluidTankInventory(FluidTankBlockEntity.getCapacityMultiplier());
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.field_11867;
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.isController()) {
            this.boiler.tick(this);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.isController()) {
            this.boiler.updateOcclusion(this);
        }
    }

    @Override
    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.field_11863.method_8608()) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.method_11002()) {
            return;
        }
        int luminosity = (int)((float)newFluidStack.getFluid().method_15785().method_15759().method_26213() / 1.2f);
        boolean reversed = false;
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    FluidTankBlockEntity tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt(this.method_11017(), (class_1922)this.field_11863, pos);
                    if (tankAt == null) continue;
                    this.field_11863.method_8455(pos, tankAt.method_11010().method_26204());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.field_11863.method_8608()) {
            this.method_5431();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
            }
            this.fluidLevel.chase(this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.updateStateLuminosity();
        this.sendData();
    }

    protected void updateStateLuminosity() {
        if (this.field_11863.method_8608()) {
            return;
        }
        int actualLuminosity = this.luminosity;
        FluidTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null || !controllerBE.window) {
            actualLuminosity = 0;
        }
        this.refreshBlockState();
        class_2680 state = this.method_11010();
        if ((Integer)state.method_11654((class_2769)FluidTankBlock.LIGHT_LEVEL) != actualLuminosity) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)FluidTankBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(actualLuminosity)), 23);
        }
    }

    public FluidTankBlockEntity getControllerBE() {
        if (this.isController() || !this.method_11002()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        int capacity = blocks * FluidTankBlockEntity.getCapacityMultiplier();
        this.tankInventory.setCapacity(capacity);
        FluidStack stack = this.tankInventory.getFluid();
        if (stack.getAmount() > capacity) {
            stack.setAmount(capacity);
            this.tankInventory.markDirty();
        }
        this.forceFluidLevelUpdate = true;
    }

    @Override
    public void removeController(boolean keepFluids) {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.boiler.clear();
        this.onFluidStackChanged(this.tankInventory.getFluid());
        class_2680 state = this.method_11010();
        if (FluidTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657(FluidTankBlock.SHAPE, (Comparable)((Object)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN)));
            this.method_10997().method_8652(this.field_11867, state, 22);
        }
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    public void toggleWindows() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void updateBoilerTemperature() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (!be.boiler.isActive()) {
            return;
        }
        be.boiler.needsHeatLevelUpdate = true;
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = this.field_11863.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.field_11863.method_8652(pos, (class_2680)blockState.method_11657(FluidTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    class_2586 be = this.field_11863.method_8321(pos);
                    if (be instanceof FluidTankBlockEntity) {
                        FluidTankBlockEntity tankAt = (FluidTankBlockEntity)be;
                        tankAt.updateStateLuminosity();
                    }
                    this.field_11863.method_8398().method_12130().method_15513(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasBoiler = this.boiler.isActive();
        boolean changed = this.boiler.evaluate(this);
        if (wasBoiler != this.boiler.isActive()) {
            if (this.boiler.isActive()) {
                this.setWindows(false);
            }
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10069(xOffset, yOffset, zOffset));
                        if (!(class_25862 instanceof FluidTankBlockEntity)) continue;
                        FluidTankBlockEntity fbe = (FluidTankBlockEntity)class_25862;
                        fbe.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.boiler.checkPipeOrganAdvancement(this);
        }
    }

    @Override
    public void setController(class_2338 controller) {
        if (this.field_11863.method_8608() && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    public void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
    }

    private FluidInventory handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    @Override
    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().method_1012((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidTankBlockEntity getOtherFluidTankBlockEntity(class_2350 direction) {
        class_2586 otherBE = this.field_11863.method_8321(this.field_11867.method_10093(direction));
        if (otherBE instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)otherBE;
        }
        return null;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean changeOfController;
        super.read(view, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = view.method_71433("Uninitialized", false);
        this.luminosity = view.method_71424("Luminosity", 0);
        this.lastKnownPos = view.method_71426("LastKnownPos", class_2338.field_25064).orElse(null);
        this.controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);
        if (this.isController()) {
            this.window = view.method_71433("Window", false);
            this.width = view.method_71424("Size", 0);
            this.height = view.method_71424("Height", 0);
            this.tankInventory.setCapacity(this.getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.read(view);
        }
        this.boiler.read(view.method_71434("Boiler"), this.width * this.width * this.height);
        if (view.method_71433("ForceFluidLevel", false) || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.method_11002()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (view.method_71433("ForceFluidLevel", false) || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
            }
            this.fluidLevel.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.method_11002()) {
            this.field_11863.method_8398().method_12130().method_15513(this.field_11867);
        }
        if (view.method_71433("LazySync", false)) {
            this.fluidLevel.chase(this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluid().getAmount() / (float)this.tankInventory.getMaxAmountPerStack();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (this.updateConnectivity) {
            view.method_71472("Uninitialized", true);
        }
        this.boiler.write(view.method_71461("Boiler"));
        if (this.lastKnownPos != null) {
            view.method_71468("LastKnownPos", class_2338.field_25064, (Object)this.lastKnownPos);
        }
        if (!this.isController()) {
            view.method_71468("Controller", class_2338.field_25064, (Object)this.controller);
        }
        if (this.isController()) {
            view.method_71472("Window", this.window);
            this.tankInventory.write(view);
            view.method_71465("Size", this.width);
            view.method_71465("Height", this.height);
        }
        view.method_71465("Luminosity", this.luminosity);
        super.write(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            view.method_71472("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            view.method_71472("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Override
    public void writeSafe(class_11372 view) {
        if (this.isController()) {
            view.method_71472("Window", this.window);
            view.method_71465("Size", this.width);
            view.method_71465("Height", this.height);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN);
    }

    public FluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 81000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (FluidTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().method_10264() == this.field_11867.method_10264()));
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().method_10264() + this.height - 1 == this.field_11867.method_10264()));
            this.field_11863.method_8652(this.field_11867, state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.method_5431();
    }

    @Override
    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Override
    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    @Override
    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return FluidTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public boolean hasTank() {
        return true;
    }

    @Override
    public int getTankSize(int tank) {
        return FluidTankBlockEntity.getCapacityMultiplier();
    }

    @Override
    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    @Override
    public FluidTank getTank(int tank) {
        return this.tankInventory;
    }

    @Override
    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    @Override
    public boolean matches(FluidStack stack, FluidStack otherStack) {
        return this.tankInventory.matches(stack, otherStack);
    }

    public class FluidTankInventory
    extends FluidTank {
        public FluidTankInventory(int capacity) {
            super(capacity);
        }

        @Override
        public void markDirty() {
            FluidTankBlockEntity.this.onFluidStackChanged(this.fluid);
        }
    }
}

