/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.content.kinetics.KineticNetwork;
import com.zurrtum.create.content.kinetics.RotationPropagator;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticEffectHandler;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class KineticBlockEntity
extends SmartBlockEntity {
    @Nullable
    public Long network;
    @Nullable
    public class_2338 source;
    public boolean networkDirty;
    public boolean updateSpeed = true;
    public int preventSpeedUpdate;
    public SequencedGearshiftBlockEntity.SequenceContext sequenceContext;
    public KineticEffectHandler effects = new KineticEffectHandler(this);
    protected float speed;
    protected float capacity;
    protected float stress;
    protected boolean overStressed;
    protected boolean wasMoved;
    protected float lastStressApplied;
    protected float lastCapacityProvided;
    private int flickerTally;
    private int networkSize;
    private int validationCountdown;

    public KineticBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    public static KineticBlockEntity encased(class_2338 pos, class_2680 state) {
        return new KineticBlockEntity(AllBlockEntityTypes.ENCASED_SHAFT, pos, state);
    }

    public static void switchToBlockState(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        class_2680 currentState = world.method_8320(pos);
        boolean isKinetic = blockEntity instanceof KineticBlockEntity;
        if (currentState == state) {
            return;
        }
        if (blockEntity == null || !isKinetic) {
            world.method_8652(pos, state, 3);
            return;
        }
        KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
        if (state.method_26204() instanceof KineticBlock && !((KineticBlock)state.method_26204()).areStatesKineticallyEquivalent(currentState, state)) {
            if (kineticBlockEntity.hasNetwork()) {
                kineticBlockEntity.getOrCreateNetwork().remove(kineticBlockEntity);
            }
            kineticBlockEntity.detachKinetics();
            kineticBlockEntity.removeSource();
        }
        if (blockEntity instanceof GeneratingKineticBlockEntity) {
            GeneratingKineticBlockEntity generatingBlockEntity = (GeneratingKineticBlockEntity)blockEntity;
            generatingBlockEntity.reActivateSource = true;
        }
        world.method_8652(pos, state, 3);
    }

    public static float convertToDirection(float axisSpeed, class_2350 d) {
        return d.method_10171() == class_2350.class_2352.field_11056 ? axisSpeed : -axisSpeed;
    }

    public static float convertToLinear(float speed) {
        return speed / 512.0f;
    }

    public static float convertToAngular(float speed) {
        return speed * 3.0f / 10.0f;
    }

    @Override
    public void initialize() {
        if (this.hasNetwork() && !this.field_11863.method_8608()) {
            KineticNetwork network = this.getOrCreateNetwork();
            if (!network.initialized) {
                network.initFromTE(this.capacity, this.stress, this.networkSize);
            }
            network.addSilently(this, this.lastCapacityProvided, this.lastStressApplied);
        }
        super.initialize();
    }

    @Override
    public void tick() {
        if (!this.field_11863.method_8608() && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        super.tick();
        this.effects.tick();
        this.preventSpeedUpdate = 0;
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.validationCountdown-- <= 0) {
            this.validationCountdown = (Integer)AllConfigs.server().kinetics.kineticValidationFrequency.get();
            this.validateKinetics();
        }
        if (this.getFlickerScore() > 0) {
            this.flickerTally = this.getFlickerScore() - 1;
        }
        if (this.networkDirty) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().updateNetwork();
            }
            this.networkDirty = false;
        }
    }

    private void validateKinetics() {
        if (this.hasSource()) {
            KineticBlockEntity sourceBE;
            if (!this.hasNetwork()) {
                this.removeSource();
                return;
            }
            if (!this.field_11863.method_22340(this.source)) {
                return;
            }
            class_2586 blockEntity = this.field_11863.method_8321(this.source);
            KineticBlockEntity kineticBlockEntity = sourceBE = blockEntity instanceof KineticBlockEntity ? (KineticBlockEntity)blockEntity : null;
            if (sourceBE == null || sourceBE.speed == 0.0f) {
                this.removeSource();
                this.detachKinetics();
                return;
            }
            return;
        }
        if (this.speed != 0.0f && this.getGeneratedSpeed() == 0.0f) {
            this.speed = 0.0f;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        this.networkDirty = false;
        this.capacity = maxStress;
        this.stress = currentStress;
        this.networkSize = networkSize;
        boolean overStressed = maxStress < currentStress && IRotate.StressImpact.isEnabled();
        this.method_5431();
        if (overStressed != this.overStressed) {
            float prevSpeed = this.getSpeed();
            this.overStressed = overStressed;
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    protected class_2248 getStressConfigKey() {
        return this.method_11010().method_26204();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact(this.getStressConfigKey());
        return impact;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)BlockStressValues.getCapacity(this.getStressConfigKey());
        return capacity;
    }

    public void onSpeedChanged(float previousSpeed) {
        boolean directionSwap;
        boolean fromOrToZero = previousSpeed == 0.0f != (this.getSpeed() == 0.0f);
        boolean bl = directionSwap = !fromOrToZero && Math.signum(previousSpeed) != Math.signum(this.getSpeed());
        if (fromOrToZero || directionSwap) {
            this.flickerTally = this.getFlickerScore() + 5;
        }
        this.method_5431();
    }

    @Override
    public void remove() {
        if (!this.field_11863.method_8608()) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove(this);
            }
            this.detachKinetics();
        }
        super.remove();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71464("Speed", this.speed);
        if (this.sequenceContext != null && (!clientPacket || this.syncSequenceContext())) {
            view.method_71468("Sequence", SequencedGearshiftBlockEntity.SequenceContext.CODEC, (Object)this.sequenceContext);
        }
        if (this.needsSpeedUpdate()) {
            view.method_71472("NeedsSpeedUpdate", true);
        }
        if (this.hasSource()) {
            view.method_71468("Source", class_2338.field_25064, (Object)this.source);
        }
        if (this.hasNetwork()) {
            class_11372 networkTag = view.method_71461("Network");
            networkTag.method_71466("Id", this.network.longValue());
            networkTag.method_71464("Stress", this.stress);
            networkTag.method_71464("Capacity", this.capacity);
            networkTag.method_71465("Size", this.networkSize);
            if (this.lastStressApplied != 0.0f) {
                networkTag.method_71464("AddedStress", this.lastStressApplied);
            }
            if (this.lastCapacityProvided != 0.0f) {
                networkTag.method_71464("AddedCapacity", this.lastCapacityProvided);
            }
        }
        super.write(view, clientPacket);
    }

    public boolean needsSpeedUpdate() {
        return this.updateSpeed;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean overStressedBefore = this.overStressed;
        this.clearKineticInformation();
        if (this.wasMoved) {
            super.read(view, clientPacket);
            return;
        }
        this.speed = view.method_71423("Speed", 0.0f);
        this.sequenceContext = view.method_71426("Sequence", SequencedGearshiftBlockEntity.SequenceContext.CODEC).orElse(null);
        this.source = view.method_71426("Source", class_2338.field_25064).orElse(null);
        view.method_71420("Network").ifPresent(networkTag -> {
            this.network = networkTag.method_71425("Id", 0L);
            this.stress = networkTag.method_71423("Stress", 0.0f);
            this.capacity = networkTag.method_71423("Capacity", 0.0f);
            this.networkSize = networkTag.method_71424("Size", 0);
            this.lastStressApplied = networkTag.method_71423("AddedStress", 0.0f);
            this.lastCapacityProvided = networkTag.method_71423("AddedCapacity", 0.0f);
            this.overStressed = this.capacity < this.stress && IRotate.StressImpact.isEnabled();
        });
        super.read(view, clientPacket);
        if (clientPacket && overStressedBefore != this.overStressed && this.speed != 0.0f) {
            this.effects.triggerOverStressedEffect();
        }
        if (clientPacket) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
    }

    public float getGeneratedSpeed() {
        return 0.0f;
    }

    public boolean isSource() {
        return this.getGeneratedSpeed() != 0.0f;
    }

    public void setSource(class_2338 source) {
        this.source = source;
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_2586 blockEntity = this.field_11863.method_8321(source);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            this.removeSource();
            return;
        }
        KineticBlockEntity sourceBE = (KineticBlockEntity)blockEntity;
        this.setNetwork(sourceBE.network);
        this.copySequenceContextFrom(sourceBE);
    }

    public float getSpeed() {
        if (this.overStressed || this.field_11863 != null && this.field_11863.method_54719().method_54754()) {
            return 0.0f;
        }
        return this.getTheoreticalSpeed();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getTheoreticalSpeed() {
        return this.speed;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
        this.sequenceContext = sourceBE.sequenceContext;
    }

    public void removeSource() {
        float prevSpeed = this.getSpeed();
        this.speed = 0.0f;
        this.source = null;
        this.setNetwork(null);
        this.sequenceContext = null;
        this.onSpeedChanged(prevSpeed);
    }

    public void setNetwork(@Nullable Long networkIn) {
        if (Objects.equals(this.network, networkIn)) {
            return;
        }
        if (this.network != null) {
            this.getOrCreateNetwork().remove(this);
        }
        this.network = networkIn;
        this.method_5431();
        if (networkIn == null) {
            return;
        }
        this.network = networkIn;
        KineticNetwork network = this.getOrCreateNetwork();
        network.initialized = true;
        network.add(this);
    }

    public KineticNetwork getOrCreateNetwork() {
        return Create.TORQUE_PROPAGATOR.getOrCreateNetworkFor(this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void attachKinetics() {
        this.updateSpeed = false;
        RotationPropagator.handleAdded(this.field_11863, this.field_11867, this);
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved(this.field_11863, this.field_11867, this);
    }

    public boolean isSpeedRequirementFulfilled() {
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)class_22482;
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        return Math.abs(this.getSpeed()) >= minimumRequiredSpeedLevel.getSpeedValue();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void clearKineticInformation() {
        this.speed = 0.0f;
        this.source = null;
        this.network = null;
        this.overStressed = false;
        this.stress = 0.0f;
        this.capacity = 0.0f;
        this.lastStressApplied = 0.0f;
        this.lastCapacityProvided = 0.0f;
    }

    public void warnOfMovement() {
        this.wasMoved = true;
    }

    public int getFlickerScore() {
        return this.flickerTally;
    }

    public boolean isOverStressed() {
        return this.overStressed;
    }

    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return 0.0f;
    }

    public List<class_2338> addPropagationLocations(IRotate block, class_2680 state, List<class_2338> neighbours) {
        if (!this.canPropagateDiagonally(block, state)) {
            return neighbours;
        }
        class_2350.class_2351 axis = block.getRotationAxis(state);
        class_2338.method_20437((class_2338)new class_2338(-1, -1, -1), (class_2338)new class_2338(1, 1, 1)).forEach(offset -> {
            if (axis.method_10173(offset.method_10263(), offset.method_10264(), offset.method_10260()) != 0) {
                return;
            }
            if (offset.method_10262(class_2338.field_11176) != 2.0) {
                return;
            }
            neighbours.add(this.field_11867.method_10081((class_2382)offset));
        });
        return neighbours;
    }

    public boolean isCustomConnection(KineticBlockEntity other, class_2680 state, class_2680 otherState) {
        return false;
    }

    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return ICogWheel.isSmallCog(state);
    }

    public boolean isNoisy() {
        return true;
    }

    public int getRotationAngleOffset(class_2350.class_2351 axis) {
        return 0;
    }

    protected boolean syncSequenceContext() {
        return false;
    }
}

