/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class HandCrankBlockEntity
extends GeneratingKineticBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public HandCrankBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HAND_CRANK, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.field_11863.method_8608()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        class_2248 block = this.method_11010().method_26204();
        if (!(block instanceof HandCrankBlock)) {
            return 0.0f;
        }
        HandCrankBlock crank = (HandCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed();
        return HandCrankBlockEntity.convertToDirection(speed, (class_2350)this.method_11010().method_11654((class_2769)HandCrankBlock.FACING));
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("InUse", this.inUse);
        view.method_71472("Backwards", this.backwards);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.inUse = view.method_71424("InUse", 0);
        this.backwards = view.method_71433("Backwards", false);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.field_11863.method_8608()) {
                this.sequenceContext = null;
                this.updateGeneratedRotation();
            }
        }
    }

    @Override
    protected class_2248 getStressConfigKey() {
        return this.method_11010().method_27852((class_2248)AllBlocks.HAND_CRANK) ? AllBlocks.HAND_CRANK : AllBlocks.COPPER_VALVE_HANDLE;
    }
}

