/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.items.BaseInventory;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class RecipeApplier {
    public static <T extends class_9695> void applyCreateRecipeOn(class_1542 entity, T input, CreateRecipe<T> recipe, boolean returnProcessingRemainder) {
        class_1937 world = entity.method_73183();
        List<class_1799> stacks = RecipeApplier.applyCreateRecipeOn(entity.method_73183(), entity.method_6983().method_7947(), input, recipe, returnProcessingRemainder);
        int size = stacks.size();
        if (size == 0) {
            entity.method_31472();
            return;
        }
        entity.method_6979(stacks.getFirst());
        if (size == 1) {
            return;
        }
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        class_243 velocity = entity.method_18798();
        for (int i = 1; i < size; ++i) {
            class_1542 entityIn = new class_1542(world, x, y, z, stacks.get(i));
            entityIn.method_18799(velocity);
            world.method_8649((class_1297)entityIn);
        }
    }

    public static <T extends class_9695> List<class_1799> applyCreateRecipeOn(class_1937 world, int count, T input, CreateRecipe<T> recipe, boolean returnProcessingRemainder) {
        ArrayList<class_1799> remainders;
        if (returnProcessingRemainder) {
            remainders = new ArrayList<class_1799>();
            int size = input.method_59983();
            for (int i = 0; i < size; ++i) {
                class_1799 recipeRemainder = input.method_59984(i).method_7909().method_7858();
                if (recipeRemainder.method_7960()) continue;
                remainders.add(recipeRemainder);
            }
            if (remainders.isEmpty()) {
                remainders = null;
            }
        } else {
            remainders = null;
        }
        if (recipe.isRollable()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            Object2ObjectOpenCustomHashMap buffer = new Object2ObjectOpenCustomHashMap(BaseInventory.ITEM_STACK_HASH_STRATEGY);
            for (int i = 0; i < count; ++i) {
                RecipeApplier.updateBuffer((Object2ObjectMap<class_1799, ObjectIntPair<class_1799>>)buffer, recipe.craft(input, world.field_9229), stacks);
                if (remainders == null) continue;
                RecipeApplier.updateBuffer((Object2ObjectMap<class_1799, ObjectIntPair<class_1799>>)buffer, remainders, stacks);
            }
            buffer.values().stream().map(Pair::left).filter(stack -> !stack.method_7960()).forEach(stacks::add);
            return stacks;
        }
        List<class_1799> craft = recipe.craft(input, world.field_9229);
        if (remainders != null) {
            remainders.addAll(craft);
            return ItemHelper.multipliedOutput(remainders, count);
        }
        return ItemHelper.multipliedOutput(craft, count);
    }

    private static void updateBuffer(Object2ObjectMap<class_1799, ObjectIntPair<class_1799>> buffer, List<class_1799> insert, List<class_1799> outputs) {
        for (class_1799 stack : insert) {
            ObjectIntPair item = (ObjectIntPair)buffer.get((Object)stack);
            if (item == null) {
                buffer.put((Object)stack, (Object)ObjectIntPair.of((Object)stack, (int)stack.method_7914()));
                continue;
            }
            int max = item.rightInt();
            class_1799 exist = (class_1799)item.left();
            int amount = stack.method_7947() + exist.method_7947();
            if (amount >= max) {
                exist.method_7939(amount - max);
                stack.method_7939(max);
                outputs.add(stack);
                continue;
            }
            exist.method_7939(amount);
        }
    }

    public static <T extends class_9695> List<class_1799> applyRecipeOn(class_1937 level, int count, T input, class_8786<? extends class_1860<T>> entry, boolean returnProcessingRemainder) {
        class_1860 recipe = entry.comp_1933();
        if (recipe instanceof CreateRecipe) {
            CreateRecipe createRecipe = (CreateRecipe)recipe;
            return RecipeApplier.applyCreateRecipeOn(level, count, input, createRecipe, returnProcessingRemainder);
        }
        return RecipeApplier.applyRecipeOn(level, count, input, recipe, returnProcessingRemainder);
    }

    public static <T extends class_9695> List<class_1799> applyRecipeOn(class_1937 level, int count, T input, class_1860<T> recipe, boolean returnProcessingRemainder) {
        class_1799 result = recipe.method_8116(input, (class_7225.class_7874)level.method_30349());
        if (returnProcessingRemainder) {
            int size = input.method_59983();
            if (size != 1) {
                ArrayList<class_1799> list = new ArrayList<class_1799>();
                for (int i = 0; i < size; ++i) {
                    class_1799 recipeRemainder = input.method_59984(i).method_7909().method_7858();
                    if (recipeRemainder.method_7960()) continue;
                    list.add(recipeRemainder);
                }
                list.add(result);
                return ItemHelper.multipliedOutput(list, count);
            }
            class_1799 recipeRemainder = input.method_59984(0).method_7909().method_7858();
            if (!recipeRemainder.method_7960()) {
                return ItemHelper.multipliedOutput(List.of(result, recipeRemainder), count);
            }
        }
        return ItemHelper.multipliedOutput(result, count);
    }
}

