/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.utility;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.schematic.nbt.PartialSafeNBT;
import com.zurrtum.create.api.schematic.nbt.SafeNbtWriterRegistry;
import com.zurrtum.create.api.schematic.state.SchematicStateFilter;
import com.zurrtum.create.api.schematic.state.SchematicStateFilterRegistry;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.IMergeableBE;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2386;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2490;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class BlockHelper {
    private static final List<class_2758> COUNT_STATES = List.of(class_2741.field_12509, class_2741.field_12543, class_2741.field_27220);
    public static final List<class_2248> VINELIKE_BLOCKS = List.of(class_2246.field_10597, class_2246.field_28411);
    public static final List<class_2746> VINELIKE_STATES = List.of(class_2741.field_12519, class_2741.field_12489, class_2741.field_12487, class_2741.field_12540, class_2741.field_12527, class_2741.field_12546);
    private static final Pair<class_1799, List<Runnable>> EMPTY_FIND = Pair.of(class_1799.field_8037, List.of());

    public static class_2680 setZeroAge(class_2680 blockState) {
        if (blockState.method_28498((class_2769)class_2741.field_12521)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12521, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12556)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12556, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12497)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12497, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12482)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12482, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12550)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12550, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12498)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12517)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12517, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_20432)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_20432, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12530)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12530, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12549)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12549, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_26164(class_3481.field_26985)) {
            return class_2246.field_10593.method_9564();
        }
        if (blockState.method_28498((class_2769)class_2741.field_17586)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_17586, (Comparable)Integer.valueOf(0));
        }
        if (blockState.method_28498((class_2769)class_2741.field_12552)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12552, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public static int findAndRemoveInInventory(class_2680 block, class_1657 player, int amount) {
        int taken;
        boolean needsTwo;
        int amountFound = 0;
        class_1792 required = BlockHelper.getRequiredItem(block).method_7909();
        boolean bl = needsTwo = block.method_28498((class_2769)class_2741.field_12485) && block.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682;
        if (needsTwo) {
            amount *= 2;
        }
        for (class_2758 class_27582 : COUNT_STATES) {
            if (!block.method_28498((class_2769)class_27582)) continue;
            amount *= ((Integer)block.method_11654((class_2769)class_27582)).intValue();
        }
        if (VINELIKE_BLOCKS.contains(block.method_26204())) {
            int vineCount = 0;
            for (class_2746 vineState : VINELIKE_STATES) {
                if (!block.method_28498((class_2769)vineState) || !((Boolean)block.method_11654((class_2769)vineState)).booleanValue()) continue;
                ++vineCount;
            }
            amount += vineCount - 1;
        }
        int preferredSlot = player.method_31548().method_67532();
        class_1799 class_17992 = player.method_31548().method_5438(preferredSlot);
        int count = class_17992.method_7947();
        if (class_17992.method_7909() == required && count > 0) {
            taken = Math.min(count, amount - amountFound);
            player.method_31548().method_5447(preferredSlot, new class_1799((class_1935)class_17992.method_7909(), count - taken));
            amountFound += taken;
        }
        for (int i = 0; i < player.method_31548().method_5439() && amountFound != amount; ++i) {
            class_1799 class_17993 = player.method_31548().method_5438(i);
            count = class_17993.method_7947();
            if (class_17993.method_7909() != required || count <= 0) continue;
            taken = Math.min(count, amount - amountFound);
            player.method_31548().method_5447(i, new class_1799((class_1935)class_17993.method_7909(), count - taken));
            amountFound += taken;
        }
        if (needsTwo) {
            if (amountFound % 2 != 0) {
                player.method_31548().method_7394(new class_1799((class_1935)required));
            }
            amountFound /= 2;
        }
        return amountFound;
    }

    public static Pair<class_1799, List<Runnable>> findInInventory(class_2680 replace, class_2680 block, class_1657 player) {
        boolean needsTwo;
        class_1792 required;
        int amountFound;
        int amount;
        block16: {
            boolean replaceable;
            block14: {
                class_2771 type;
                block15: {
                    amount = 1;
                    amountFound = 0;
                    required = BlockHelper.getRequiredItem(block).method_7909();
                    needsTwo = false;
                    replaceable = replace.method_45474();
                    if (!block.method_28498((class_2769)class_2741.field_12485)) break block14;
                    type = (class_2771)block.method_11654((class_2769)class_2741.field_12485);
                    if (!replaceable) break block15;
                    if (type != class_2771.field_12682) break block16;
                    needsTwo = true;
                    amount = 2;
                    break block16;
                }
                class_2771 replaceType = (class_2771)replace.method_11654((class_2769)class_2741.field_12485);
                if (replaceType != type && replaceType != class_2771.field_12682) break block16;
                amount = 0;
                break block16;
            }
            if (VINELIKE_BLOCKS.contains(block.method_26204())) {
                replaceable = replaceable && !replace.method_27852(block.method_26204());
                int vineCount = 0;
                for (class_2746 vineState : VINELIKE_STATES) {
                    if (!block.method_28498((class_2769)vineState) || !((Boolean)block.method_11654((class_2769)vineState)).booleanValue() || !replaceable && ((Boolean)replace.method_11654((class_2769)vineState)).booleanValue()) continue;
                    ++vineCount;
                }
                amount += vineCount - 1;
            } else {
                for (class_2758 property : COUNT_STATES) {
                    if (!block.method_28498((class_2769)property)) continue;
                    amount = (Integer)block.method_11654((class_2769)property);
                    if (replaceable) break;
                    amount -= ((Integer)replace.method_11654((class_2769)property)).intValue();
                    break;
                }
            }
        }
        class_1661 inventory = player.method_31548();
        ArrayList<Runnable> task = new ArrayList<Runnable>();
        int preferredSlot = inventory.method_67532();
        if (amountFound != amount) {
            class_1799 itemstack = inventory.method_5438(preferredSlot);
            int count = itemstack.method_7947();
            if (itemstack.method_7909() == required && count > 0) {
                int taken = Math.min(count, amount - amountFound);
                if (count == taken) {
                    task.add(() -> inventory.method_5447(preferredSlot, class_1799.field_8037));
                } else {
                    task.add(() -> itemstack.method_7939(count - taken));
                }
                amountFound += taken;
            }
        }
        if (amountFound != amount) {
            int size = inventory.method_5439();
            for (int i = 0; i < size; ++i) {
                if (i == preferredSlot) continue;
                class_1799 itemstack = inventory.method_5438(i);
                int count = itemstack.method_7947();
                if (itemstack.method_7909() != required || count <= 0) continue;
                int taken = Math.min(count, amount - amountFound);
                int slot = i;
                if (count == taken) {
                    task.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                } else {
                    task.add(() -> itemstack.method_7939(count - taken));
                }
                if ((amountFound += taken) == amount) break;
            }
        }
        if (needsTwo && amountFound != 2) {
            amountFound = 0;
        }
        if (amountFound == 0) {
            return EMPTY_FIND;
        }
        task.add(() -> ((class_1661)inventory).method_5431());
        return Pair.of(new class_1799((class_1935)required, amountFound), task);
    }

    public static class_1799 getRequiredItem(class_2680 state) {
        class_1799 itemStack = new class_1799((class_1935)state.method_26204());
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8365 || item == class_1802.field_8519) {
            itemStack = new class_1799((class_1935)class_1802.field_8831);
        }
        return itemStack;
    }

    public static void destroyBlock(class_1937 world, class_2338 pos, float effectChance) {
        BlockHelper.destroyBlock(world, pos, effectChance, stack -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack));
    }

    public static void destroyBlock(class_1937 world, class_2338 pos, float effectChance, Consumer<class_1799> droppedItemCallback) {
        BlockHelper.destroyBlockAs(world, pos, null, class_1799.field_8037, effectChance, droppedItemCallback);
    }

    public static void destroyBlockAs(class_1937 world, class_2338 pos, @Nullable class_1657 player, class_1799 usedTool, float effectChance, Consumer<class_1799> droppedItemCallback) {
        class_3218 serverLevel;
        class_2586 blockEntity;
        class_3610 fluidState = world.method_8316(pos);
        class_2680 state = world.method_8320(pos);
        if (world.field_9229.method_43057() < effectChance) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
        class_2586 class_25862 = blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        if (player != null) {
            usedTool.method_7952(world, state, pos, player);
            player.method_7259(class_3468.field_15427.method_14956((Object)state.method_26204()));
        }
        if (world instanceof class_3218 && (serverLevel = (class_3218)world).method_64395().method_8355(class_1928.field_19392) && (player == null || !player.method_68878())) {
            class_2680 below;
            List drops = class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)usedTool);
            if (player != null) {
                // empty if block
            }
            for (class_1799 itemStack : drops) {
                droppedItemCallback.accept(itemStack);
            }
            class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
            if (state.method_26204() instanceof class_2386 && usedTool.method_58657().method_57536((class_6880)enchantmentRegistry.method_46747(class_1893.field_9099)) == 0 && !world.method_8597().comp_644() && ((below = world.method_8320(pos.method_10074())).method_51366() || below.method_51176())) {
                fluidState = class_2386.method_51170().method_26227();
            }
            state.method_26180(serverLevel, pos, class_1799.field_8037, true);
        }
        world.method_8501(pos, fluidState.method_15759());
    }

    public static boolean isSolidWall(class_1922 reader, class_2338 fromPos, class_2350 toDirection) {
        return BlockHelper.hasBlockSolidSide(reader.method_8320(fromPos.method_10093(toDirection)), reader, fromPos.method_10093(toDirection), toDirection.method_10153());
    }

    public static boolean noCollisionInSpace(class_1922 reader, class_2338 pos) {
        return reader.method_8320(pos).method_26220(reader, pos).method_1110();
    }

    private static void placeRailWithoutUpdate(class_1937 world, class_2680 state, class_2338 target) {
        int idx;
        class_2818 chunk = world.method_8500(target);
        class_2826 chunksection = chunk.method_38259(idx = chunk.method_31602(target.method_10264()));
        if (chunksection == null) {
            chunk.method_12006()[idx] = chunksection = new class_2826(world.method_74142());
        }
        class_2680 old = chunksection.method_16675(class_4076.method_18684((int)target.method_10263()), class_4076.method_18684((int)target.method_10264()), class_4076.method_18684((int)target.method_10260()), state);
        chunk.method_65063();
        BlockHelper.markAndNotifyBlock(world, target, chunk, old, state, 82);
        world.method_8652(target, state, 83);
        class_2338 down = target.method_10074();
        class_2248 sourceBlock = world.method_8320(down).method_26204();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof NeighborUpdateListeningBlock) {
            NeighborUpdateListeningBlock block = (NeighborUpdateListeningBlock)class_22482;
            block.neighborUpdate(state, world, target, sourceBlock, down, false);
        }
        world.method_8492(target, sourceBlock, null);
    }

    public static void markAndNotifyBlock(class_1937 world, class_2338 pos, class_2818 worldChunk, class_2680 blockState, class_2680 state, int flags) {
        class_2680 blockState2 = world.method_8320(pos);
        if (blockState2 == state) {
            if (blockState != blockState2) {
                world.method_16109(pos, blockState, blockState2);
            }
            if ((flags & 2) != 0 && (!world.method_8608() || (flags & 4) == 0) && (world.method_8608() || worldChunk.method_12225() != null && worldChunk.method_12225().method_14014(class_3194.field_44856))) {
                world.method_8413(pos, blockState, state, flags);
            }
            if ((flags & 1) != 0) {
                world.method_8408(pos, blockState.method_26204());
                if (!world.method_8608() && state.method_26221()) {
                    world.method_8455(pos, state.method_26204());
                }
            }
            if ((flags & 0x10) == 0) {
                int i = flags & 0xFFFFFFDE;
                blockState.method_26198((class_1936)world, pos, i, 511);
                state.method_26183((class_1936)world, pos, i, 511);
                state.method_26198((class_1936)world, pos, i, 511);
            }
            world.method_66016(pos, blockState, blockState2);
        }
    }

    public static class_2487 prepareBlockEntityData(class_1937 level, class_2680 blockState, class_2586 blockEntity) {
        class_2487 data = null;
        if (blockEntity == null) {
            return null;
        }
        class_5455 access = level.method_30349();
        SafeNbtWriterRegistry.SafeNbtWriter writer = SafeNbtWriterRegistry.REGISTRY.get(blockEntity.method_11017());
        if (blockState.method_26164(AllBlockTags.SAFE_NBT)) {
            data = blockEntity.method_38242((class_7225.class_7874)access);
        } else if (writer != null) {
            data = new class_2487();
            writer.writeSafe(blockEntity, data, (class_7225.class_7874)access);
        } else if (blockEntity instanceof PartialSafeNBT) {
            PartialSafeNBT safeNbtBE = (PartialSafeNBT)blockEntity;
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Create.LOGGER);){
                class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)access);
                safeNbtBE.writeSafe((class_11372)view);
                data = view.method_71475();
            }
        }
        return NBTProcessors.process(blockState, blockEntity, data, true);
    }

    public static void placeSchematicBlock(class_1937 world, class_2680 state, class_2338 target, class_1799 stack, @Nullable class_2487 data) {
        class_2248 block = state.method_26204();
        class_2586 existingBlockEntity = world.method_8321(target);
        boolean alreadyPlaced = false;
        SchematicStateFilterRegistry.StateFilter filter = SchematicStateFilterRegistry.REGISTRY.get((class_2688<class_2248, ?>)state);
        if (filter != null) {
            state = filter.filterStates(existingBlockEntity, state);
        } else if (block instanceof SchematicStateFilter) {
            SchematicStateFilter schematicStateFilter = (SchematicStateFilter)block;
            state = schematicStateFilter.filterStates(existingBlockEntity, state);
        }
        if (state.method_28498((class_2769)class_2741.field_12552)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12552, (Comparable)Boolean.FALSE);
        }
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.FALSE);
        }
        if (block == class_2246.field_17563) {
            state = class_2246.field_17563.method_9564();
        } else if (state.method_26164(class_3481.field_26985)) {
            state = class_2246.field_10593.method_9564();
        }
        if (world.method_8597().comp_644() && state.method_26227().method_15767(class_3486.field_15517)) {
            int i = target.method_10263();
            int j = target.method_10264();
            int k = target.method_10260();
            world.method_8396(null, target, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.method_8406((class_2394)class_2398.field_11237, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            class_2248.method_9497((class_2680)state, (class_1937)world, (class_2338)target);
            return;
        }
        if (!alreadyPlaced) {
            if (state.method_26204() instanceof class_2241) {
                BlockHelper.placeRailWithoutUpdate(world, state, target);
            } else if (state.method_27852((class_2248)AllBlocks.BELT)) {
                world.method_8652(target, state, 2);
            } else {
                world.method_8652(target, state, 18);
            }
        }
        if (data != null) {
            class_2586 blockEntity;
            if (existingBlockEntity instanceof IMergeableBE) {
                IMergeableBE mergeable = (IMergeableBE)existingBlockEntity;
                class_2586 loaded = class_2586.method_11005((class_2338)target, (class_2680)state, (class_2487)data, (class_7225.class_7874)world.method_30349());
                if (loaded != null && existingBlockEntity.method_11017().equals(loaded.method_11017())) {
                    mergeable.accept(loaded);
                    return;
                }
            }
            if ((blockEntity = world.method_8321(target)) != null) {
                IMultiBlockEntityContainer imbe;
                data.method_10569("x", target.method_10263());
                data.method_10569("y", target.method_10264());
                data.method_10569("z", target.method_10260());
                if (blockEntity instanceof KineticBlockEntity) {
                    KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
                    kbe.warnOfMovement();
                }
                if (blockEntity instanceof IMultiBlockEntityContainer && !(imbe = (IMultiBlockEntityContainer)blockEntity).isController()) {
                    data.method_67494("Controller", class_2338.field_25064, (Object)imbe.getController());
                }
                try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Create.LOGGER);){
                    blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)data));
                }
            }
        }
        try {
            state.method_26204().method_9567(world, target, state, null, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double getBounceMultiplier(class_2248 block) {
        if (block instanceof class_2490) {
            return 0.8;
        }
        if (block instanceof class_2244) {
            return 0.528;
        }
        return 0.0;
    }

    public static boolean hasBlockSolidSide(class_2680 state, class_1922 blockGetter, class_2338 pos, class_2350 dir) {
        return !state.method_26164(class_3481.field_15503) && class_2248.method_9501((class_265)state.method_26220(blockGetter, pos), (class_2350)dir);
    }

    public static boolean extinguishFire(class_1937 world, @Nullable class_1657 player, class_2338 pos, class_2350 dir) {
        if (world.method_8320(pos = pos.method_10093(dir)).method_26204() == class_2246.field_10036) {
            world.method_8444((class_1297)player, 1009, pos, 0);
            world.method_8650(pos, false);
            return true;
        }
        return false;
    }

    public static class_2680 copyProperties(class_2680 fromState, class_2680 toState) {
        for (class_2769 property : fromState.method_28501()) {
            toState = BlockHelper.copyProperty(property, fromState, toState);
        }
        return toState;
    }

    public static <T extends Comparable<T>> class_2680 copyProperty(class_2769<T> property, class_2680 fromState, class_2680 toState) {
        if (fromState.method_28498(property) && toState.method_28498(property)) {
            return (class_2680)toState.method_11657(property, fromState.method_11654(property));
        }
        return toState;
    }

    public static boolean isNotUnheated(class_2680 state) {
        if (state.method_26164(class_3481.field_23799) && state.method_28498((class_2769)class_3922.field_17352)) {
            return (Boolean)state.method_11654((class_2769)class_3922.field_17352);
        }
        if (state.method_28498(BlazeBurnerBlock.HEAT_LEVEL)) {
            return state.method_11654(BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE;
        }
        return true;
    }

    public static class_1269 invokeUse(class_2680 state, class_1937 level, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1269 interactionresult;
        class_1269 iteminteractionresult = state.method_55780(player.method_5998(hand), level, player, hand, ray);
        if (iteminteractionresult.method_23665()) {
            return iteminteractionresult;
        }
        if (iteminteractionresult == class_1269.field_52423 && hand == class_1268.field_5808 && (interactionresult = state.method_55781(level, player, ray)).method_23665()) {
            return interactionresult;
        }
        return class_1269.field_5811;
    }
}

