/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BaseSidedInventory
extends class_1263 {
    default public int[] create$getAvailableSlots(class_2350 side) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$canInsert(int slot, class_1799 stack, @Nullable class_2350 dir) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public boolean create$canExtract(int slot, class_1799 stack, class_2350 dir) {
        throw new RuntimeException("Implemented via Mixin");
    }

    default public int count(class_1799 stack) {
        return this.count(stack, null);
    }

    default public int count(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount, side);
    }

    default public int count(class_1799 stack, int maxAmount) {
        return this.count(stack, maxAmount, null);
    }

    default public int count(class_1799 stack, int maxAmount, class_2350 side) {
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.method_5438(slot)).method_7960() || !this.matches(target, stack) || (count += target.method_7947()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public class_1799 count(Predicate<class_1799> predicate) {
        return this.count(predicate, null);
    }

    default public class_1799 count(Predicate<class_1799> predicate, class_2350 side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !this.create$canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return class_1799.field_8037;
    }

    default public class_1799 count(Predicate<class_1799> predicate, int maxAmount) {
        return this.count(predicate, maxAmount, null);
    }

    default public class_1799 count(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            class_1799 findStack = this.method_5438(slot);
            if (findStack.method_7960() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                class_1799 stack = this.method_5438(slot);
                if (!stack.method_7960() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack) && (count += stack.method_7947()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return class_1799.field_8037;
    }

    default public int countAll(Predicate<class_1799> predicate, int maxAmount) {
        return this.countAll(predicate, maxAmount, null);
    }

    default public int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side) || (count += stack.method_7947()) < maxAmount) continue;
            return maxAmount;
        }
        return count;
    }

    default public class_1799 countAny() {
        return this.countAny(null);
    }

    default public class_1799 countAny(class_2350 side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            if (target.method_7960() || !this.create$canExtract(slot, target, side)) continue;
            return this.onExtract(this.directCopy(target, target.method_7947()));
        }
        return class_1799.field_8037;
    }

    default public class_1799 countAny(int maxAmount) {
        return this.extractAny(maxAmount, null);
    }

    default public class_1799 countAny(int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            class_1799 findStack = this.method_5438(slot);
            if (findStack.method_7960() || !this.create$canExtract(slot, findStack, side)) continue;
            int count = findStack.method_7947();
            if (count >= maxAmount) {
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                class_1799 stack = this.method_5438(slot);
                if (!stack.method_7960() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack) && (count += stack.method_7947()) >= maxAmount) {
                    return this.onExtract(this.directCopy(findStack, maxAmount));
                }
                ++i;
            }
            return this.onExtract(this.directCopy(findStack, count));
        }
        return class_1799.field_8037;
    }

    default public int countSpace(class_1799 stack) {
        return this.countSpace(stack, null);
    }

    default public int countSpace(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount, side);
    }

    default public int countSpace(class_1799 stack, int maxAmount) {
        return this.countSpace(stack, maxAmount, null);
    }

    default public int countSpace(class_1799 stack, int maxAmount, class_2350 side) {
        int count = 0;
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target;
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack) || !((target = this.method_5438(slot)).method_7960() ? (count += this.method_58350(stack) - target.method_7947()) >= maxAmount : this.matches(target, stack) && (count += target.method_7914() - target.method_7947()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public int countSpace(class_1799 stack, int maxAmount, int start, int end) {
        return this.countSpace(stack, maxAmount, start, end, null);
    }

    default public int countSpace(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        int count = 0;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return 0;
        }
        for (int i = start; i <= end; ++i) {
            class_1799 target;
            int slot = slots[i];
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack) || !((target = this.method_5438(slot)).method_7960() ? (count += this.method_58350(stack) - target.method_7947()) >= maxAmount : this.matches(target, stack) && (count += target.method_7914() - target.method_7947()) >= maxAmount)) continue;
            return maxAmount;
        }
        return count;
    }

    default public boolean countSpace(List<class_1799> stacks) {
        return this.countSpace(stacks, null);
    }

    default public boolean countSpace(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            class_1799 stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.method_7947(), side) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), side) == count;
        }
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$canInsert(slot, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.method_5437(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.method_58350(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean countSpace(List<class_1799> stacks, int start, int end) {
        return this.countSpace(stacks, start, end, null);
    }

    default public boolean countSpace(List<class_1799> stacks, int start, int end, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            class_1799 stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.method_7947(), start, end, side) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue(), start, end, side) == count;
        }
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return false;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return false;
        }
        for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            class_1799 target = this.method_5438(slot);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$canInsert(slot, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.method_5437(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.method_58350(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    return true;
                }
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public int extract(class_1799 stack) {
        return this.extract(stack, null);
    }

    default public int extract(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount, side);
    }

    default public int extract(class_1799 stack, int maxAmount) {
        return this.extract(stack, maxAmount, null);
    }

    default public int extract(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.method_5438(slot)).method_7960() || !this.matches(target, stack)) continue;
            int count = target.method_7947();
            if (count > remaining) {
                target.method_7939(count - remaining);
                this.method_5431();
                return maxAmount;
            }
            this.method_5447(slot, class_1799.field_8037);
            if (count == remaining) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= count;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    default public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
        return this.extract(predicate, maxAmount, null);
    }

    default public class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            class_1799 findStack = this.method_5438(slot);
            if (findStack.method_7960() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.method_5431();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.method_5447(slot, class_1799.field_8037);
            if (count == maxAmount) {
                this.method_5431();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                class_1799 stack = this.method_5438(slot);
                if (!stack.method_7960() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        this.method_5447(slot, class_1799.field_8037);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.method_5431();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.method_5431();
            findStack.method_7939(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return class_1799.field_8037;
    }

    default public class_1799 extract(Predicate<class_1799> predicate) {
        return this.extract(predicate, null);
    }

    default public class_1799 extract(Predicate<class_1799> predicate, class_2350 side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !this.create$canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            this.method_5447(slot, class_1799.field_8037);
            this.method_5431();
            return this.onExtract(stack);
        }
        return class_1799.field_8037;
    }

    default public List<class_1799> extract(List<class_1799> stacks) {
        return this.extract(stacks, null);
    }

    default public List<class_1799> extract(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (extract = this.extract(stack, side))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count, side))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        boolean dirty = false;
        block1: for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            if (target.method_7960() || !this.create$canExtract(slot, target, side)) continue;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int remaining;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.matches(target, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey())) continue;
                int count = target.method_7947();
                if (count < (remaining = entry.getIntValue())) {
                    this.method_5447(slot, class_1799.field_8037);
                    entry.setValue(remaining - count);
                    continue block1;
                }
                if (count == remaining) {
                    this.method_5447(slot, class_1799.field_8037);
                } else {
                    target.method_7939(count - remaining);
                }
                iterator.remove();
                if (entries.isEmpty()) {
                    this.method_5431();
                    return List.of();
                }
                dirty = true;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.method_5431();
            return result;
        }
        return stacks;
    }

    default public int extractAll(Predicate<class_1799> predicate, int maxAmount) {
        return this.extractAll(predicate, maxAmount, null);
    }

    default public int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side)) continue;
            int count = stack.method_7947();
            if (count < remaining) {
                this.method_5447(slot, class_1799.field_8037);
                remaining -= count;
                continue;
            }
            if (count == remaining) {
                this.method_5447(slot, class_1799.field_8037);
            } else {
                stack.method_7939(count - remaining);
            }
            this.method_5431();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    default public class_1799 extractAny() {
        return this.extractAny(null);
    }

    default public class_1799 extractAny(class_2350 side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            if (target.method_7960() || !this.create$canExtract(slot, target, side)) continue;
            this.method_5447(slot, class_1799.field_8037);
            this.method_5431();
            return this.onExtract(target);
        }
        return class_1799.field_8037;
    }

    default public class_1799 extractAny(int maxAmount) {
        return this.extractAny(maxAmount, null);
    }

    default public class_1799 extractAny(int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            class_1799 findStack = this.method_5438(slot);
            if (findStack.method_7960() || !this.create$canExtract(slot, findStack, side)) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.method_5431();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            this.method_5447(slot, class_1799.field_8037);
            if (count == maxAmount) {
                this.method_5431();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                class_1799 stack = this.method_5438(slot);
                if (!stack.method_7960() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        this.method_5447(slot, class_1799.field_8037);
                        remaining -= count;
                    } else {
                        if (count == remaining) {
                            this.method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.method_5431();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.method_5431();
            findStack.method_7939(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return class_1799.field_8037;
    }

    private int findEndIndex(int[] slots, int start, int end) {
        for (int i = slots.length - 1; i >= start; --i) {
            if (slots[i] > end) continue;
            return i;
        }
        return -1;
    }

    private int findStartIndex(int[] slots, int start) {
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            if (slots[i] < start) continue;
            return i;
        }
        return -1;
    }

    default public int insert(class_1799 stack) {
        return this.insert(stack, null);
    }

    default public int insert(class_1799 stack, int maxAmount) {
        return this.insert(stack, maxAmount, null);
    }

    default public int insert(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount, side);
    }

    default public int insert(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack)) continue;
            class_1799 target = this.method_5438(slot);
            if (target.method_7960()) {
                int insert = Math.min(remaining, this.method_58350(stack));
                this.method_5447(slot, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.method_5431();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    default public int insert(class_1799 stack, int maxAmount, int start, int end) {
        return this.insert(stack, maxAmount, start, end, null);
    }

    default public int insert(class_1799 stack, int maxAmount, int start, int end, class_2350 side) {
        int remaining = maxAmount;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return 0;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return 0;
        }
        for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack)) continue;
            class_1799 target = this.method_5438(slot);
            if (target.method_7960()) {
                int insert = Math.min(remaining, this.method_58350(stack));
                this.method_5447(slot, this.directCopy(stack, insert));
                if (remaining == insert) {
                    this.method_5431();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    default public List<class_1799> insert(List<class_1799> stacks) {
        return this.insert(stacks, null);
    }

    default public List<class_1799> insert(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (insert = this.insert(stack, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        block1: for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$canInsert(slot, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.method_5437(slot, stack)) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.method_58350(stack));
                    this.method_5447(slot, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.method_5431();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.method_7939(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.method_5431();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.method_5431();
            return result;
        }
        return stacks;
    }

    default public List<class_1799> insert(List<class_1799> stacks, int start, int end) {
        return this.insert(stacks, start, end, null);
    }

    default public List<class_1799> insert(List<class_1799> stacks, int start, int end, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            class_1799 stack = stacks.getFirst();
            int count = stack.method_7947();
            if (count == (insert = this.insert(stack, count, start, end, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count, start, end, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        boolean dirty = false;
        int[] slots = this.create$getAvailableSlots(side);
        start = this.findStartIndex(slots, start);
        if (start == -1) {
            return stacks;
        }
        if ((end = this.findEndIndex(slots, start, end)) == -1) {
            return stacks;
        }
        block1: for (int i = start; i <= end; ++i) {
            int slot = slots[i];
            class_1799 target = this.method_5438(slot);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$canInsert(slot, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.method_5437(slot, stack)) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.method_58350(stack));
                    this.method_5447(slot, this.directCopy(stack, insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.method_5431();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxCount - count);
                target.method_7939(count + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.method_5431();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                class_1799 stack = (class_1799)entry.getKey();
                int count = entry.getIntValue();
                if (stack.method_7947() == count) {
                    result.add(stack);
                    continue;
                }
                result.add(this.directCopy(stack, count));
            }
            this.method_5431();
            return result;
        }
        return stacks;
    }

    default public int insertExist(class_1799 stack) {
        return this.insertExist(stack, null);
    }

    default public int insertExist(class_1799 stack, int maxAmount) {
        return this.insertExist(stack, maxAmount, null);
    }

    default public int insertExist(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount, side);
    }

    default public int insertExist(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack)) continue;
            class_1799 target = this.method_5438(slot);
            if (target.method_7960()) {
                emptys.add(slot);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(remaining, maxCount - count);
            target.method_7939(count + insert);
            if (remaining == insert) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        Object object = emptys.iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            int insert = Math.min(remaining, this.method_58350(stack));
            this.method_5447(slot, this.directCopy(stack, insert));
            if (remaining == insert) {
                this.method_5431();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.method_5431();
        return maxAmount - remaining;
    }

    @NotNull
    default public java.util.Iterator<class_1799> iterator() {
        return this.iterator(null);
    }

    @NotNull
    default public java.util.Iterator<class_1799> iterator(class_2350 side) {
        return new Iterator(this, side);
    }

    default public boolean preciseExtract(class_1799 stack) {
        return this.preciseExtract(stack, null);
    }

    default public boolean preciseExtract(class_1799 stack, class_2350 side) {
        if (stack.method_7960()) {
            return true;
        }
        int remaining = stack.method_7947();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target;
            if (!this.create$canExtract(slot, stack, side) || (target = this.method_5438(slot)).method_7960() || !this.matches(target, stack)) continue;
            int count = target.method_7947();
            if (count > remaining) {
                changes.forEach(Runnable::run);
                target.method_7939(count - remaining);
                this.method_5431();
                return true;
            }
            if (count == remaining) {
                changes.forEach(Runnable::run);
                this.method_5447(slot, class_1799.field_8037);
                this.method_5431();
                return true;
            }
            changes.add(() -> this.method_5447(slot, class_1799.field_8037));
            remaining -= count;
        }
        return false;
    }

    default public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
        return this.preciseExtract(predicate, maxAmount, null);
    }

    default public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        int[] slots = this.create$getAvailableSlots(side);
        int size = slots.length;
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            class_1799 findStack = this.method_5438(slot);
            if (findStack.method_7960() || !this.create$canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int count = findStack.method_7947();
            if (count > maxAmount) {
                findStack.method_7939(count - maxAmount);
                this.method_5431();
                return this.onExtract(this.directCopy(findStack, maxAmount));
            }
            if (count == maxAmount) {
                this.method_5447(slot, class_1799.field_8037);
                this.method_5431();
                return this.onExtract(findStack);
            }
            buffer.add(slot);
            int remaining = maxAmount - count;
            ++i;
            while (i < size) {
                slot = slots[i];
                class_1799 stack = this.method_5438(slot);
                if (!stack.method_7960() && this.create$canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    count = stack.method_7947();
                    if (count < remaining) {
                        buffer.add(slot);
                        remaining -= count;
                    } else {
                        buffer.forEach(j -> this.method_5447((int)j, class_1799.field_8037));
                        if (count == remaining) {
                            this.method_5447(slot, class_1799.field_8037);
                        } else {
                            stack.method_7939(count - remaining);
                        }
                        this.method_5431();
                        findStack.method_7939(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return class_1799.field_8037;
    }

    default public boolean preciseInsert(class_1799 stack) {
        return this.preciseInsert(stack, null);
    }

    default public boolean preciseInsert(class_1799 stack, class_2350 side) {
        int maxAmount = stack.method_7947();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount, side);
    }

    default public boolean preciseInsert(class_1799 stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount, null);
    }

    default public boolean preciseInsert(class_1799 stack, int maxAmount, class_2350 side) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            if (!this.create$canInsert(slot, stack, side) || !this.method_5437(slot, stack)) continue;
            class_1799 target = this.method_5438(slot);
            if (target.method_7960()) {
                int insert = Math.min(maxAmount, this.method_58350(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.method_5447(slot, this.directCopy(stack, insert));
                    this.method_5431();
                    return true;
                }
                changes.add(() -> this.method_5447(slot, this.directCopy(stack, insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.method_7914();
            int count = target.method_7947();
            if (count == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - count);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.method_7939(count + insert);
                this.method_5431();
                return true;
            }
            changes.add(() -> target.method_7939(count + insert));
            maxAmount -= insert;
        }
        return false;
    }

    default public boolean preciseInsert(List<class_1799> stacks) {
        return this.preciseInsert(stacks, null);
    }

    default public boolean preciseInsert(List<class_1799> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst(), side);
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (class_1799 stack : stacks) {
            map.merge((Object)stack, stack.method_7947(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((class_1799)entry.getKey(), entry.getIntValue(), side);
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 target = this.method_5438(slot);
            boolean empty = target.method_7960();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                class_1799 stack;
                if (!this.create$canInsert(slot, stack = (class_1799)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.method_5437(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.method_58350(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        changes.forEach(Runnable::run);
                        this.method_5447(slot, this.directCopy(stack, insert2));
                        this.method_5431();
                        return true;
                    }
                    changes.add(() -> this.method_5447(slot, this.directCopy(stack, insert2)));
                    entry.setValue(remaining - insert2);
                    continue;
                }
                if (!this.matches(target, stack)) continue;
                int maxCount = target.method_7914();
                int count = target.method_7947();
                if (count == maxCount) continue;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxCount - count))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue;
                    changes.forEach(Runnable::run);
                    target.method_7939(count + insert);
                    this.method_5431();
                    return true;
                }
                changes.add(() -> target.method_7939(count + insert));
                entry.setValue(remaining - insert);
            } while (iterator.hasNext());
        }
        return false;
    }

    default public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update) {
        return this.update(predicate, update, null);
    }

    default public boolean update(Predicate<class_1799> predicate, Function<class_1799, class_1799> update, class_2350 side) {
        for (int slot : this.create$getAvailableSlots(side)) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack) || !this.create$canExtract(slot, stack, side)) continue;
            class_1799 replace = update.apply(stack);
            if (replace != stack) {
                this.method_5447(slot, replace);
            }
            this.method_5431();
            return true;
        }
        return false;
    }

    public static class Iterator
    implements java.util.Iterator<class_1799> {
        private final BaseSidedInventory inventory;
        private final class_2350 side;
        private final int[] slots;
        private int index;
        private int current = -1;

        public Iterator(BaseSidedInventory inventory, class_2350 side) {
            this.inventory = inventory;
            this.side = side;
            this.slots = inventory.create$getAvailableSlots(side);
        }

        @Override
        public boolean hasNext() {
            if (this.current >= 0) {
                return true;
            }
            if (this.current == -2) {
                return false;
            }
            while (this.index < this.slots.length) {
                class_1799 stack = this.inventory.method_5438(this.slots[this.index]);
                if (this.inventory.create$canExtract(this.index, stack, this.side)) {
                    this.current = this.index++;
                    return true;
                }
                ++this.index;
            }
            this.current = -2;
            return false;
        }

        @Override
        public class_1799 next() {
            if (this.hasNext()) {
                class_1799 result = this.inventory.method_5438(this.slots[this.current]);
                this.current = -1;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

