/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemStackHandler
implements ItemInventory {
    public static final Codec<ItemStackHandler> CODEC = Codec.of(ItemStackHandler::encode, ItemStackHandler::decode);
    protected final class_2371<class_1799> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public class_1799 method_5438(int slot) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.stacks.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= this.method_5439()) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
    }

    public class_2371<class_1799> getStacks() {
        return this.stacks;
    }

    public void writeSlots(class_11372 view) {
        view.method_71468("Inventory", CreateCodecs.ITEM_LIST_CODEC, this.stacks);
    }

    public void readSlots(class_11368 view) {
        view.method_71426("Inventory", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(list -> {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.stacks.set(i, (Object)((class_1799)list.get(i)));
            }
        }, () -> this.stacks.clear());
    }

    public void write(class_11372 view) {
        class_11372.class_11373 list = view.method_71467("Inventory", class_1799.field_24671);
        for (class_1799 stack : this.stacks) {
            if (stack.method_7960()) continue;
            list.method_71484((Object)stack);
        }
    }

    public void read(class_11368 view) {
        class_11368.class_11369 list = view.method_71437("Inventory", class_1799.field_24671);
        int i = 0;
        for (class_1799 itemStack : list) {
            this.stacks.set(i++, (Object)itemStack);
        }
        int size = this.stacks.size();
        while (i < size) {
            this.stacks.set(i, (Object)class_1799.field_8037);
            ++i;
        }
    }

    private static <T> DataResult<T> encode(ItemStackHandler input, DynamicOps<T> ops, T prefix) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Size", ops.createInt(input.stacks.size()));
        ListBuilder list = ops.listBuilder();
        for (class_1799 stack : input.stacks) {
            if (stack.method_7960()) continue;
            list.add(class_1799.field_24671.encodeStart(ops, (Object)stack));
        }
        map.add("Stacks", list.build(ops.empty()));
        return map.build(prefix);
    }

    private static <T> DataResult<Pair<ItemStackHandler, T>> decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        int size = ((Number)ops.getNumberValue(map.get("Size")).getOrThrow()).intValue();
        ItemStackHandler handler = new ItemStackHandler(size);
        MutableInt i = new MutableInt();
        ((Consumer)ops.getList(map.get("Stacks")).getOrThrow()).accept(item -> handler.stacks.set(i.getAndIncrement(), (Object)class_1799.field_24671.parse(ops, item).result().orElse(class_1799.field_8037)));
        return DataResult.success((Object)Pair.of((Object)handler, (Object)ops.empty()));
    }
}

