/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.illusivesoulworks.comforts.mixin.AccessorPlayer;
import com.illusivesoulworks.comforts.platform.Services;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public abstract class BaseComfortsBlock
extends class_2244
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final BedType type;

    public BaseComfortsBlock(BedType type, class_1767 colorIn, class_4970.class_2251 properties) {
        super(colorIn, properties);
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_9967, (Comparable)class_2742.field_12557)).method_11657((class_2769)field_9968, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static class_2350 getDirectionToOther(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    @Nonnull
    public class_1269 method_55766(@Nonnull class_2680 state, class_1937 level, @Nonnull class_2338 pos, @Nonnull class_1657 player, @Nonnull class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_21466;
        }
        if (state.method_11654((class_2769)field_9967) != class_2742.field_12560 && !(state = level.method_8320(pos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177)))).method_27852((class_2248)this)) {
            return class_1269.field_21466;
        }
        if (!BaseComfortsBlock.method_27352((class_1937)level)) {
            level.method_8650(pos, false);
            class_2338 blockpos = pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_10153());
            if (level.method_8320(blockpos).method_27852((class_2248)this)) {
                level.method_8650(blockpos, false);
            }
            class_243 vec3 = pos.method_46558();
            level.method_46407(null, level.method_48963().method_48808(vec3), null, vec3, 5.0f, true, class_1937.class_7867.field_40889);
            return class_1269.field_5812;
        }
        if (((Boolean)state.method_11654((class_2769)field_9968)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.method_7353((class_2561)class_2561.method_43471((String)("item.comforts." + this.type.name + ".occupied")), true);
            }
            return class_1269.field_5812;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            BaseComfortsBlock.trySleep(serverPlayer, pos, false).ifLeft(result -> {
                if (result != null) {
                    class_2561 text;
                    switch (result) {
                        case field_7529: {
                            class_2561 message = ComfortsConfig.ComfortsTimeUse.NIGHT.getMessage();
                            if (this.type == BedType.HAMMOCK) {
                                message = ((ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.hammockUse.get()))).getMessage();
                            } else if (this.type == BedType.SLEEPING_BAG) {
                                message = ((ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()))).getMessage();
                            }
                            class_2561 class_25612 = message;
                            break;
                        }
                        case field_7530: {
                            class_2561 class_25612 = class_2561.method_43471((String)("item.comforts." + this.type.name + ".too_far_away"));
                            break;
                        }
                        default: {
                            class_2561 class_25612 = text = result.method_19206();
                        }
                    }
                    if (text != null) {
                        player.method_7353(text, true);
                    }
                }
            });
        }
        return class_1269.field_5812;
    }

    public static Either<class_1657.class_1658, class_3902> trySleep(class_3222 player, class_2338 at, boolean dryRun) {
        class_1657.class_1658 ret = Services.SLEEP_EVENTS.getSleepResult(player, at);
        Either result = null;
        if (ret != null) {
            return Either.left((Object)ret);
        }
        class_2350 direction = player.method_51469().method_8320(at).method_28500((class_2769)class_2383.field_11177).orElse(player.method_5735());
        if (!player.method_6113() && player.method_5805()) {
            if (!player.method_51469().method_8597().comp_645()) {
                result = Either.left((Object)class_1657.class_1658.field_7528);
            } else if (!BaseComfortsBlock.bedInRange(player, at, direction)) {
                result = Either.left((Object)class_1657.class_1658.field_7530);
            } else if (BaseComfortsBlock.bedBlocked(player, at, direction)) {
                result = Either.left((Object)class_1657.class_1658.field_18592);
            } else if (Services.SLEEP_EVENTS.isAwakeTime((class_1657)player, at)) {
                result = Either.left((Object)class_1657.class_1658.field_7529);
            } else {
                if (!player.method_68878()) {
                    double d0 = 8.0;
                    double d1 = 5.0;
                    class_243 vector3d = class_243.method_24955((class_2382)at);
                    List list = player.method_51469().method_8390(class_1588.class, new class_238(vector3d.method_10216() - 8.0, vector3d.method_10214() - 5.0, vector3d.method_10215() - 8.0, vector3d.method_10216() + 8.0, vector3d.method_10214() + 5.0, vector3d.method_10215() + 8.0), monster -> monster.method_7076(player.method_51469(), (class_1657)player));
                    if (!list.isEmpty()) {
                        result = Either.left((Object)class_1657.class_1658.field_7532);
                    }
                }
                if (result == null) {
                    result = Either.right((Object)class_3902.field_17274);
                }
            }
        } else {
            result = Either.left((Object)class_1657.class_1658.field_7531);
        }
        result = Services.SLEEP_EVENTS.getSleepResult(player, at, (Either<class_1657.class_1658, class_3902>)result);
        if (!dryRun && result.right().isPresent()) {
            BaseComfortsBlock comfortsBlock;
            class_2248 block = player.method_51469().method_8320(at).method_26204();
            if (block instanceof BaseComfortsBlock && !(comfortsBlock = (BaseComfortsBlock)block).canRest()) {
                int time = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429));
                player.method_18403(at);
                player.method_14248().method_15023((class_1657)player, class_3468.field_15419.method_14956((Object)class_3468.field_15429), time);
            } else {
                player.method_18403(at);
            }
            ((AccessorPlayer)player).setSleepCounter(0);
            player.method_7281(class_3468.field_15381);
            class_174.field_1212.method_9141(player);
            player.method_51469().method_8448();
        }
        return result;
    }

    protected abstract boolean canRest();

    private static boolean bedInRange(class_3222 playerEntity, class_2338 blockPos, class_2350 direction) {
        if (direction == null) {
            return false;
        }
        return BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos) || BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos.method_10093(direction.method_10153()));
    }

    private static boolean isReachableBedBlock(class_3222 playerEntity, class_2338 blockPos) {
        class_243 vector3d = class_243.method_24955((class_2382)blockPos);
        return Math.abs(playerEntity.method_23317() - vector3d.method_10216()) <= 3.0 && Math.abs(playerEntity.method_23318() - vector3d.method_10214()) <= 2.0 && Math.abs(playerEntity.method_23321() - vector3d.method_10215()) <= 3.0;
    }

    private static boolean bedBlocked(class_3222 playerEntity, class_2338 blockPos, class_2350 direction) {
        class_2338 blockpos = blockPos.method_10084();
        return BaseComfortsBlock.isAbnormalCube((class_1937)playerEntity.method_51469(), blockpos) || BaseComfortsBlock.isAbnormalCube((class_1937)playerEntity.method_51469(), blockpos.method_10093(direction.method_10153()));
    }

    private static boolean isAbnormalCube(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26228((class_1922)world, pos);
    }

    private boolean kickVillagerOutOfBed(class_1937 level, class_2338 blockPos) {
        List list = level.method_8390(class_1646.class, new class_238(blockPos), class_1309::method_6113);
        if (list.isEmpty()) {
            return false;
        }
        ((class_1646)list.getFirst()).method_18400();
        return true;
    }

    @Nonnull
    public class_2680 method_9576(class_1937 level, @Nonnull class_2338 pos, @Nonnull class_2680 state, @Nonnull class_1657 player) {
        class_2338 blockpos;
        class_2680 blockstate;
        class_2742 bedpart;
        if (!level.method_8608() && player.method_68878() && (bedpart = (class_2742)state.method_11654((class_2769)field_9967)) == class_2742.field_12557 && (blockstate = level.method_8320(blockpos = pos.method_10093(BaseComfortsBlock.getDirectionToOther(bedpart, (class_2350)state.method_11654((class_2769)field_11177))))).method_26204() == this && blockstate.method_11654((class_2769)field_9967) == class_2742.field_12560) {
            if (((Boolean)blockstate.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                level.method_8652(blockpos, class_2246.field_10382.method_9564(), 35);
            } else {
                level.method_8652(blockpos, class_2246.field_10124.method_9564(), 35);
            }
            level.method_8444((class_1297)player, 2001, blockpos, class_2248.method_9507((class_2680)blockstate));
        }
        level.method_8444((class_1297)player, 2001, pos, BaseComfortsBlock.method_9507((class_2680)state));
        if (state.method_26164(class_3481.field_23800)) {
            class_4838.method_24733((class_3218)((class_3218)player.method_73183()), (class_1657)player, (boolean)false);
        }
        return state;
    }

    @Nonnull
    protected class_2680 method_9559(class_2680 stateIn, @NotNull class_4538 levelReader, @NotNull class_10225 tickAccess, @NotNull class_2338 currentPos, @NotNull class_2350 facing, @NotNull class_2338 facingPos, @NotNull class_2680 facingState, @NotNull class_5819 randomSource) {
        if (((Boolean)stateIn.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickAccess.method_64312(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return super.method_9559(stateIn, levelReader, tickAccess, currentPos, facing, facingPos, facingState, randomSource);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 ifluidstate = context.method_8045().method_8316(context.method_8037());
        class_2680 state = super.method_9605(context);
        return state == null ? null : (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
        super.method_9515(builder);
    }

    @Nonnull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9567(@Nonnull class_1937 level, @Nonnull class_2338 pos, @Nonnull class_2680 state, @Nullable class_1309 livingEntity, @Nonnull class_1799 stack) {
        super.method_9567(level, pos, state, livingEntity, stack);
        class_2338 blockPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177));
        if (stack.method_58694(class_9334.field_49631) != null) {
            level.method_35230(blockPos, this.getBlockEntityType()).ifPresent(blockEntity -> blockEntity.setName(stack.method_7964()));
        }
    }

    public abstract class_2591<? extends BaseComfortsBlockEntity> getBlockEntityType();

    public static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

