/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_5878;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.config.ConfigData;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class ConfigManager {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final String CONFIG_PATH = "config/cosycritters.json";
    public static ConfigData config;
    public static ConfigData defaultConfig;
    public static class_5878 mothGroup;
    public static class_5878 birdGroup;
    public static class_5878 spiderGroup;

    public static void loadConfig() {
        File file = new File(CONFIG_PATH);
        try (FileReader reader = new FileReader(file);){
            config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
        }
        catch (IOException e) {
            CosyCritters.LOGGER.error(e.getMessage());
        }
        if (config == null || ConfigManager.config.configVersion < ConfigManager.defaultConfig.configVersion) {
            config = new ConfigData();
            ConfigManager.saveConfig();
        }
        mothGroup = new class_5878(ConfigManager.config.maxMoths);
        birdGroup = new class_5878(ConfigManager.config.maxBirds);
        spiderGroup = new class_5878(ConfigManager.config.maxSpiders);
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            CosyCritters.LOGGER.error(e.getMessage());
        }
    }

    static {
        defaultConfig = new ConfigData();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Dropdown {
        public Class<? extends Supplier<List<String>>> supplier();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EditAsString {
    }

    public static class resetParticles
    implements Runnable {
        @Override
        public void run() {
            ((ParticleEngineAccessor)class_310.method_1551().field_1713).callClearParticles();
            mothGroup = new class_5878(ConfigManager.config.maxMoths);
            birdGroup = new class_5878(ConfigManager.config.maxBirds);
            spiderGroup = new class_5878(ConfigManager.config.maxSpiders);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnChange {
        public Class<? extends Runnable> runnable();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoGUI {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Group {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BooleanFormat {
        public String t();

        public String f();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Label {
        public String key();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OverrideName {
        public String newName();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Percentage {
    }
}

