/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8002;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.impl.ui.StyledElement;
import snownee.jade.util.JadeCodecs;

public class BoxStyle
implements Cloneable {
    private static final int[] DEFAULT_PADDING = new int[]{3, 3, 3, 3};
    public static final Codec<BoxStyle> CODEC = RecordCodecBuilder.create(i -> i.group((App)JadeCodecs.floatArrayCodec(4, (Codec<Float>)Codec.FLOAT).optionalFieldOf("boxProgressOffset").forGetter($ -> Optional.ofNullable($.boxProgressOffset)), (App)ColorPalette.CODEC.optionalFieldOf("boxProgressColors", (Object)ColorPalette.DEFAULT).forGetter($ -> $.boxProgressColors), (App)JadeCodecs.intArrayCodec(4, (Codec<Integer>)Codec.INT).optionalFieldOf("padding").forGetter($ -> Optional.ofNullable($.padding)), (App)Codec.INT.optionalFieldOf("borderWidth", (Object)1).forGetter($ -> $.borderWidth), (App)class_2960.field_25139.optionalFieldOf("sprite").forGetter($ -> Optional.ofNullable($.sprite)), (App)class_2960.field_25139.optionalFieldOf("withIconSprite").forGetter($ -> Optional.ofNullable($.withIconSprite)), (App)Codec.BOOL.optionalFieldOf("tooltip", (Object)false).forGetter($ -> $.tooltip)).apply((Applicative)i, BoxStyle::new));
    private static final BoxStyle TRANSPARENT = BoxStyle.sprite(null, null, 0);
    public static final BoxStyle DEFAULT_NESTED_BOX = BoxStyle.sprite(JadeIds.JADE("nested_box"), null);
    public static final BoxStyle DEFAULT_VIEW_GROUP = BoxStyle.sprite(JadeIds.JADE("view_group"), new int[]{2, 2, 2, 2}, 0);
    public final float[] boxProgressOffset;
    public final int[] padding;
    public int borderWidth;
    public ColorPalette boxProgressColors;
    @Nullable
    public class_2960 sprite;
    @Nullable
    public class_2960 withIconSprite;
    public boolean tooltip;

    public BoxStyle(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding, int borderWidth, Optional<class_2960> sprite, Optional<class_2960> withIconSprite, boolean tooltip) {
        this.boxProgressOffset = boxProgressOffset.orElse(null);
        this.boxProgressColors = boxProgressColors;
        this.padding = padding.orElseGet(() -> (int[])DEFAULT_PADDING.clone());
        this.borderWidth = borderWidth;
        this.sprite = sprite.orElse(null);
        this.withIconSprite = withIconSprite.orElse(null);
        this.tooltip = tooltip;
    }

    public static BoxStyle nestedBox() {
        return IThemeHelper.get().theme().nestedBoxStyle;
    }

    public static BoxStyle viewGroup() {
        return IThemeHelper.get().theme().viewGroupStyle;
    }

    public static BoxStyle transparent() {
        return TRANSPARENT;
    }

    public static BoxStyle simple(@Nullable class_2960 sprite, @Nullable int[] padding) {
        return new BoxStyle(Optional.empty(), ColorPalette.DEFAULT, Optional.ofNullable(padding), 1, Optional.ofNullable(sprite), Optional.empty(), false);
    }

    public static BoxStyle tooltip(@Nullable class_2960 sprite, @Nullable int[] padding) {
        return BoxStyle.tooltip(sprite, padding, 1);
    }

    public static BoxStyle tooltip(@Nullable class_2960 sprite, @Nullable int[] padding, int borderWidth) {
        return new BoxStyle(Optional.empty(), ColorPalette.DEFAULT, Optional.ofNullable(padding), borderWidth, Optional.ofNullable(sprite), Optional.empty(), true);
    }

    public static BoxStyle sprite(@Nullable class_2960 sprite, @Nullable int[] padding) {
        return BoxStyle.sprite(sprite, padding, 1);
    }

    public static BoxStyle sprite(@Nullable class_2960 sprite, @Nullable int[] padding, int borderWidth) {
        return new BoxStyle(Optional.empty(), ColorPalette.DEFAULT, Optional.ofNullable(padding), borderWidth, Optional.ofNullable(sprite), Optional.empty(), false);
    }

    public float boxProgressOffset(ScreenDirection dir) {
        return this.boxProgressOffset == null ? 0.0f : this.boxProgressOffset[dir.ordinal()];
    }

    public int padding(ScreenDirection dir) {
        return ((int[])MoreObjects.firstNonNull((Object)this.padding, (Object)DEFAULT_PADDING))[dir.ordinal()];
    }

    public void render(class_332 guiGraphics, StyledElement element, float x, float y, float w, float h, float alpha) {
        class_2960 texture = this.sprite;
        if (this.withIconSprite != null && element.getIcon() != null) {
            texture = this.withIconSprite;
        }
        if (texture == null) {
            return;
        }
        int roundedX = Math.round(x);
        int roundedY = Math.round(y);
        int roundedW = Math.round(w);
        int roundedH = Math.round(h);
        int col = class_9848.method_61317((float)alpha);
        if (this.tooltip) {
            roundedW = roundedW + 9 + 9;
            roundedH = roundedH + 9 + 9;
            guiGraphics.method_52707(class_10799.field_56883, class_8002.method_64049((class_2960)texture), roundedX -= 9, roundedY -= 9, roundedW, roundedH, col);
            guiGraphics.method_52707(class_10799.field_56883, class_8002.method_64051((class_2960)texture), roundedX, roundedY, roundedW, roundedH, col);
        } else {
            guiGraphics.method_52707(class_10799.field_56883, texture, roundedX, roundedY, roundedW, roundedH, col);
        }
    }

    public int borderWidth() {
        return this.borderWidth;
    }

    public BoxStyle clone() {
        return new BoxStyle(JadeCodecs.nullableClone(this.boxProgressOffset), this.boxProgressColors, JadeCodecs.nullableClone(this.padding), this.borderWidth, Optional.ofNullable(this.sprite), Optional.ofNullable(this.withIconSprite), this.tooltip);
    }
}

