/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.gson.JsonElement;
import fi.dy.masa.malilib.config.ConfigType;
import java.util.Locale;
import javax.annotation.Nullable;

public interface IConfigBase {
    public ConfigType getType();

    public String getName();

    default public String getLowerName() {
        return this.getName().toLowerCase(Locale.ROOT);
    }

    default public String getCleanName() {
        String result = this.getName();
        if (result.contains(".")) {
            result = result.replace('.', '_');
        }
        return result;
    }

    @Nullable
    public String getComment();

    default public String getPrettyName() {
        return this.getName();
    }

    default public String getConfigGuiDisplayName() {
        return this.getTranslatedName();
    }

    public String getTranslatedName();

    public void setPrettyName(String var1);

    public void setTranslatedName(String var1);

    public void setComment(String var1);

    public boolean isDirty();

    public void markDirty();

    public void markClean();

    public void checkIfClean();

    public void setValueFromJsonElement(JsonElement var1);

    public JsonElement getAsJsonElement();
}

