/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fi.dy.masa.malilib.MaLiLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    public static boolean hasBoolean(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsBoolean();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasInteger(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsInt();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasLong(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsLong();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasFloat(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsFloat();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasDouble(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsDouble();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasString(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsString();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasObject(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonObject();
    }

    public static boolean hasArray(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonArray();
    }

    public static boolean getBooleanOrDefault(JsonObject obj, String name, boolean defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntegerOrDefault(JsonObject obj, String name, int defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongOrDefault(JsonObject obj, String name, long defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(JsonObject obj, String name, float defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsFloat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(JsonObject obj, String name, double defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getStringOrDefault(JsonObject obj, String name, String defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonObject obj, String name) {
        return JsonUtils.getBooleanOrDefault(obj, name, false);
    }

    public static int getInteger(JsonObject obj, String name) {
        return JsonUtils.getIntegerOrDefault(obj, name, 0);
    }

    public static long getLong(JsonObject obj, String name) {
        return JsonUtils.getLongOrDefault(obj, name, 0L);
    }

    public static float getFloat(JsonObject obj, String name) {
        return JsonUtils.getFloatOrDefault(obj, name, 0.0f);
    }

    public static double getDouble(JsonObject obj, String name) {
        return JsonUtils.getDoubleOrDefault(obj, name, 0.0);
    }

    @Nullable
    public static String getString(JsonObject obj, String name) {
        return JsonUtils.getStringOrDefault(obj, name, null);
    }

    public static boolean hasBlockPos(JsonObject obj, String name) {
        return JsonUtils.blockPosFromJson(obj, name) != null;
    }

    public static JsonArray blockPosToJson(class_2338 pos) {
        JsonArray arr = new JsonArray();
        arr.add((Number)pos.method_10263());
        arr.add((Number)pos.method_10264());
        arr.add((Number)pos.method_10260());
        return arr;
    }

    @Nullable
    public static class_2338 blockPosFromJson(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new class_2338(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean hasVec3d(JsonObject obj, String name) {
        return JsonUtils.vec3dFromJson(obj, name) != null;
    }

    public static JsonArray vec3dToJson(class_243 vec) {
        JsonArray arr = new JsonArray();
        arr.add((Number)vec.field_1352);
        arr.add((Number)vec.field_1351);
        arr.add((Number)vec.field_1350);
        return arr;
    }

    @Nullable
    public static class_243 vec3dFromJson(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new class_243(arr.get(0).getAsDouble(), arr.get(1).getAsDouble(), arr.get(2).getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public static JsonObject deepCopy(@Nonnull JsonObject jsonObject) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            result.add((String)entry.getKey(), JsonUtils.deepCopy((JsonElement)entry.getValue()));
        }
        return result;
    }

    @Nonnull
    public static JsonArray deepCopy(@Nonnull JsonArray jsonArray) {
        JsonArray result = new JsonArray();
        for (JsonElement e : jsonArray) {
            result.add(JsonUtils.deepCopy(e));
        }
        return result;
    }

    @Nonnull
    public static JsonElement deepCopy(@Nonnull JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() || jsonElement.isJsonNull()) {
            return jsonElement;
        }
        if (jsonElement.isJsonObject()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonArray()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonArray());
        }
        throw new UnsupportedOperationException("Unsupported element: " + String.valueOf(jsonElement));
    }

    @Nullable
    public static JsonElement parseJsonFile(File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            JsonElement jsonElement;
            String fileName = file.getAbsolutePath();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MaLiLib.LOGGER.error("Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
                }
            }
            reader.close();
            return jsonElement;
        }
        return null;
    }

    public static boolean writeJsonToFile(JsonObject root, File file) {
        boolean bl;
        File fileTmp = new File(file.getParentFile(), file.getName() + ".tmp");
        if (fileTmp.exists()) {
            fileTmp = new File(file.getParentFile(), String.valueOf(UUID.randomUUID()) + ".tmp");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTmp), StandardCharsets.UTF_8);
        try {
            writer.write(GSON.toJson((JsonElement)root));
            writer.close();
            if (file.exists() && file.isFile() && !file.delete()) {
                MaLiLib.LOGGER.warn("Failed to delete file '{}'", (Object)file.getAbsolutePath());
            }
            bl = fileTmp.renameTo(file);
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MaLiLib.LOGGER.warn("Failed to write JSON data to file '{}'", (Object)fileTmp.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    @Nullable
    public static JsonElement parseJsonFileAsPath(Path file) {
        if (file != null && Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
            JsonElement jsonElement;
            String fileName = file.toString();
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MaLiLib.LOGGER.error("parseJson: Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
                }
            }
            reader.close();
            return jsonElement;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean writeJsonToFileAsPath(JsonObject root, Path file) {
        Path fileTemp = Path.of(file.toString() + ".tmp", new String[0]);
        if (Files.exists(fileTemp, new LinkOption[0])) {
            fileTemp = Path.of(file.toString() + String.valueOf(UUID.randomUUID()) + ".tmp", new String[0]);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(fileTemp, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(GSON.toJson((JsonElement)root));
            writer.close();
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    Files.delete(file);
                }
                catch (Exception err) {
                    MaLiLib.LOGGER.warn("writeJson: Failed to delete file '{}'", (Object)file.toString());
                }
            }
            try {
                Files.move(fileTemp, file, new CopyOption[0]);
                boolean err = true;
                return err;
            }
            catch (Exception err) {
                MaLiLib.LOGGER.warn("writeJson: Failed to move file '{}'", (Object)file.toString());
                writer.close();
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("writeJson: Failed to write JSON data to file '{}'", (Object)fileTemp.toString(), (Object)e);
        }
        return false;
    }
}

