/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class ListData
extends BaseData {
    public static final String TAG_NAME = "TAG_List";
    protected final ArrayList<BaseData> list;
    protected final int containedType;

    public ListData(int containedType) {
        this(containedType, new ArrayList<BaseData>());
    }

    public ListData(int containedType, ArrayList<BaseData> list) {
        super(9, TAG_NAME);
        this.containedType = containedType;
        this.list = list;
    }

    public int getContainedType() {
        return this.containedType;
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public boolean remove(int index) {
        if (index < this.list.size()) {
            this.list.remove(index);
            return true;
        }
        return false;
    }

    public boolean add(BaseData entry) {
        if (entry.getType() != this.containedType) {
            return false;
        }
        this.list.add(entry);
        return true;
    }

    public BaseData get(int index) {
        return this.list.get(index);
    }

    public byte getByteAt(int index) {
        if (this.containedType == 1) {
            return ((ByteData)this.list.get((int)index)).value;
        }
        return 0;
    }

    public short getShortAt(int index) {
        if (this.containedType == 2) {
            return ((ShortData)this.list.get((int)index)).value;
        }
        return 0;
    }

    public int getIntAt(int index) {
        if (this.containedType == 3) {
            return ((IntData)this.list.get((int)index)).value;
        }
        return 0;
    }

    public long getLongAt(int index) {
        if (this.containedType == 4) {
            return ((LongData)this.list.get((int)index)).value;
        }
        return 0L;
    }

    public float getFloatAt(int index) {
        if (this.containedType == 5) {
            return ((FloatData)this.list.get((int)index)).value;
        }
        return 0.0f;
    }

    public double getDoubleAt(int index) {
        if (this.containedType == 6) {
            return ((DoubleData)this.list.get((int)index)).value;
        }
        return 0.0;
    }

    public CompoundData getCompoundAt(int index) {
        if (this.containedType == 10) {
            return (CompoundData)this.list.get(index);
        }
        return new CompoundData();
    }

    @Override
    public BaseData copy() {
        ListData copy = new ListData(this.containedType);
        for (BaseData data : this.list) {
            copy.list.add(data.copy());
        }
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.list.get(i).toString());
        }
        return sb.append(']').toString();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        int containedType = this.list.isEmpty() ? 0 : this.containedType;
        int listSize = this.list.size();
        output.writeByte(containedType);
        output.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            this.list.get(i).write(output);
        }
    }

    public static ListData read(DataInput input, int depth, SizeTracker sizeTracker) throws IOException {
        if (depth > 512) {
            throw new IOException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        byte tagType = input.readByte();
        int len = input.readInt();
        sizeTracker.increment(5);
        if (tagType == 0 && len > 0) {
            throw new IOException("ListData of type TAG_End");
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)len);
        for (int i = 0; i < len; ++i) {
            BaseData data = BaseData.createTag(tagType, input, depth + 1, sizeTracker);
            if (data == null) {
                throw new IOException("ListData: Failed to read entry at index " + i);
            }
            list.add(data);
        }
        return new ListData((int)tagType, list);
    }
}

