/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.chat.ComponentStyleSerializer;
import net.md_5.bungee.chat.VersionedComponentSerializer;

public class BaseComponentSerializer {
    protected final VersionedComponentSerializer serializer;

    protected void deserialize(JsonObject object, BaseComponent component, JsonDeserializationContext context) {
        JsonElement extra;
        JsonObject hoverEventJson;
        boolean newHoverEvent;
        JsonObject clickEvent;
        boolean newClickEvent;
        component.applyStyle((ComponentStyle)context.deserialize((JsonElement)object, ComponentStyle.class));
        JsonElement insertion = object.get("insertion");
        if (insertion != null) {
            component.setInsertion(insertion.getAsString());
        }
        boolean bl = newClickEvent = (clickEvent = object.getAsJsonObject("click_event")) != null;
        if (!newClickEvent) {
            clickEvent = object.getAsJsonObject("clickEvent");
        }
        if (clickEvent != null) {
            ClickEvent.Action action = ClickEvent.Action.valueOf(clickEvent.get("action").getAsString().toUpperCase(Locale.ROOT));
            if (newClickEvent) {
                switch (action) {
                    case OPEN_URL: {
                        component.setClickEvent(new ClickEvent(action, clickEvent.get("url").getAsString()));
                        break;
                    }
                    case RUN_COMMAND: 
                    case SUGGEST_COMMAND: {
                        component.setClickEvent(new ClickEvent(action, clickEvent.get("command").getAsString()));
                        break;
                    }
                    case CHANGE_PAGE: {
                        int page = clickEvent.get("page").getAsInt();
                        Preconditions.checkArgument((page >= 0 ? 1 : 0) != 0, (Object)"Page number has to be positive");
                        component.setClickEvent(new ClickEvent(action, Integer.toString(page)));
                        break;
                    }
                    default: {
                        component.setClickEvent(new ClickEvent(action, clickEvent.has("value") ? clickEvent.get("value").getAsString() : ""));
                        break;
                    }
                }
            } else {
                component.setClickEvent(new ClickEvent(action, clickEvent.has("value") ? clickEvent.get("value").getAsString() : ""));
            }
        }
        boolean bl2 = newHoverEvent = (hoverEventJson = object.getAsJsonObject("hover_event")) != null;
        if (!newHoverEvent) {
            hoverEventJson = object.getAsJsonObject("hoverEvent");
        }
        if (hoverEventJson != null) {
            HoverEvent hoverEvent = null;
            HoverEvent.Action action = HoverEvent.Action.valueOf(hoverEventJson.get("action").getAsString().toUpperCase(Locale.ROOT));
            if (newHoverEvent || hoverEventJson.has("contents")) {
                JsonElement contents = hoverEventJson.get(newHoverEvent ? "value" : "contents");
                if (contents != null || newHoverEvent && (action == HoverEvent.Action.SHOW_ITEM || action == HoverEvent.Action.SHOW_ENTITY)) {
                    if (contents == null) {
                        contents = hoverEventJson;
                    }
                    Content[] list = contents.isJsonArray() ? (Content[])context.deserialize(contents, HoverEvent.getClass(action, true)) : new Content[]{(Content)context.deserialize(contents, HoverEvent.getClass(action, false))};
                    hoverEvent = new HoverEvent(action, new ArrayList<Content>(Arrays.asList(list)));
                }
            } else {
                JsonElement value = hoverEventJson.get("value");
                if (value != null) {
                    BaseComponent[] components = value.isJsonArray() ? (BaseComponent[])context.deserialize(value, BaseComponent[].class) : new BaseComponent[]{(BaseComponent)context.deserialize(value, BaseComponent.class)};
                    hoverEvent = new HoverEvent(action, components);
                }
            }
            if (hoverEvent != null) {
                component.setHoverEvent(hoverEvent);
            }
        }
        if ((extra = object.get("extra")) != null) {
            component.setExtra(Arrays.asList((BaseComponent[])context.deserialize(extra, BaseComponent[].class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(JsonObject object, BaseComponent component, JsonSerializationContext context) {
        boolean first = false;
        if (VersionedComponentSerializer.serializedComponents.get() == null) {
            first = true;
            VersionedComponentSerializer.serializedComponents.set(Collections.newSetFromMap(new IdentityHashMap()));
        }
        try {
            Preconditions.checkArgument((!VersionedComponentSerializer.serializedComponents.get().contains(component) ? 1 : 0) != 0, (Object)"Component loop");
            VersionedComponentSerializer.serializedComponents.get().add(component);
            ComponentStyleSerializer.serializeTo(component.getStyle(), object);
            if (component.getInsertion() != null) {
                object.addProperty("insertion", component.getInsertion());
            }
            if (component.getClickEvent() != null) {
                JsonObject clickEvent = new JsonObject();
                String actionName = component.getClickEvent().getAction().toString().toLowerCase(Locale.ROOT);
                clickEvent.addProperty("action", actionName.toLowerCase(Locale.ROOT));
                switch (this.serializer.getVersion()) {
                    case V1_21_5: {
                        ClickEvent.Action action = ClickEvent.Action.valueOf(actionName.toUpperCase(Locale.ROOT));
                        switch (action) {
                            case OPEN_URL: {
                                clickEvent.addProperty("url", component.getClickEvent().getValue());
                                break;
                            }
                            case RUN_COMMAND: 
                            case SUGGEST_COMMAND: {
                                clickEvent.addProperty("command", component.getClickEvent().getValue());
                                break;
                            }
                            case CHANGE_PAGE: {
                                clickEvent.addProperty("page", (Number)Integer.parseInt(component.getClickEvent().getValue()));
                                break;
                            }
                            default: {
                                clickEvent.addProperty("value", component.getClickEvent().getValue());
                            }
                        }
                        object.add("click_event", (JsonElement)clickEvent);
                        break;
                    }
                    case V1_16: {
                        clickEvent.addProperty("value", component.getClickEvent().getValue());
                        object.add("clickEvent", (JsonElement)clickEvent);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown version " + (Object)((Object)this.serializer.getVersion()));
                    }
                }
            }
            if (component.getHoverEvent() != null) {
                JsonObject hoverEvent = new JsonObject();
                hoverEvent.addProperty("action", component.getHoverEvent().getAction().toString().toLowerCase(Locale.ROOT));
                if (component.getHoverEvent().isLegacy()) {
                    hoverEvent.add("value", context.serialize((Object)component.getHoverEvent().getContents().get(0)));
                } else {
                    switch (this.serializer.getVersion()) {
                        case V1_21_5: {
                            if (component.getHoverEvent().getAction() == HoverEvent.Action.SHOW_ITEM || component.getHoverEvent().getAction() == HoverEvent.Action.SHOW_ENTITY) {
                                JsonObject inlined = context.serialize(component.getHoverEvent().getContents().size() == 1 ? component.getHoverEvent().getContents().get(0) : component.getHoverEvent().getContents()).getAsJsonObject();
                                inlined.entrySet().forEach(entry -> hoverEvent.add((String)entry.getKey(), (JsonElement)entry.getValue()));
                                break;
                            }
                            hoverEvent.add("value", context.serialize(component.getHoverEvent().getContents().size() == 1 ? component.getHoverEvent().getContents().get(0) : component.getHoverEvent().getContents()));
                            break;
                        }
                        case V1_16: {
                            hoverEvent.add("contents", context.serialize(component.getHoverEvent().getContents().size() == 1 ? component.getHoverEvent().getContents().get(0) : component.getHoverEvent().getContents()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown version " + (Object)((Object)this.serializer.getVersion()));
                        }
                    }
                }
                switch (this.serializer.getVersion()) {
                    case V1_21_5: {
                        object.add("hover_event", (JsonElement)hoverEvent);
                        break;
                    }
                    case V1_16: {
                        object.add("hoverEvent", (JsonElement)hoverEvent);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown version " + (Object)((Object)this.serializer.getVersion()));
                    }
                }
            }
            if (component.getExtra() != null) {
                object.add("extra", context.serialize(component.getExtra()));
            }
        }
        finally {
            VersionedComponentSerializer.serializedComponents.get().remove(component);
            if (first) {
                VersionedComponentSerializer.serializedComponents.set(null);
            }
        }
    }

    @Generated
    public BaseComponentSerializer(VersionedComponentSerializer serializer) {
        this.serializer = serializer;
    }
}

