/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.services;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.neoforge.services.NeoForgeRegisterItemHelper;
import com.natamus.collective_common_neoforge.services.helpers.RegisterBlockHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeRegisterBlockHelper
implements RegisterBlockHelper {
    private static final HashMap<String, DeferredRegister.Blocks> deferredBlockRegisterMap = new HashMap();
    private static final HashMap<ResourceLocation, DeferredBlock<Block>> registeredBlocksWithoutItem = new HashMap();
    private static final HashMap<ResourceLocation, Pair<DeferredBlock<Block>, DeferredItem<Item>>> registeredBlockWithItemPairs = new HashMap();

    @Override
    public <T extends Block> void registerBlockWithoutItem(Object modEventBusObject, ResourceLocation resourceLocation, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, boolean lastBlock) {
        NeoForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, resourceLocation, blockFunction, properties, null, lastBlock, false);
    }

    @Override
    public Block getRegisteredBlockWithoutItem(ResourceLocation resourceLocation) {
        return (Block)registeredBlocksWithoutItem.get(resourceLocation).get();
    }

    @Override
    public <T extends Block> void registerBlockWithItem(Object modEventBusObject, ResourceLocation resourceLocation, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock) {
        NeoForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, resourceLocation, blockFunction, properties, creativeModeTabResourceKey, lastBlock, true);
    }

    @Override
    public Block getRegisteredBlockWithItem(ResourceLocation resourceLocation) {
        return (Block)((DeferredBlock)registeredBlockWithItemPairs.get(resourceLocation).getFirst()).get();
    }

    @Override
    public Pair<Block, BlockItem> getRegisteredBlockWithItemPair(ResourceLocation resourceLocation) {
        Pair<DeferredBlock<Block>, DeferredItem<Item>> deferredPair = registeredBlockWithItemPairs.get(resourceLocation);
        return Pair.of((Object)((Block)((DeferredBlock)deferredPair.getFirst()).get()), (Object)((BlockItem)((DeferredItem)deferredPair.getSecond()).get()));
    }

    @Override
    public void setRegisteredBlockWithItemPair(ResourceLocation resourceLocation, Class<?> blockClass, String blockFieldName, Class<?> blockItemClass, String blockItemFieldName) {
        Pair<DeferredBlock<Block>, DeferredItem<Item>> deferredPair = registeredBlockWithItemPairs.get(resourceLocation);
        try {
            Field blockField = blockClass.getDeclaredField(blockFieldName);
            blockField.setAccessible(true);
            blockField.set(null, ((DeferredBlock)deferredPair.getFirst()).get());
            Field blockItemField = blockItemClass.getDeclaredField(blockItemFieldName);
            blockItemField.setAccessible(true);
            blockItemField.set(null, ((DeferredItem)deferredPair.getSecond()).get());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static <T extends Block> void staticRegisterBlock(Object modEventBusObject, ResourceLocation resourceLocation, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock, boolean registerAsItem) {
        String namespace = resourceLocation.getNamespace();
        if (!deferredBlockRegisterMap.containsKey(namespace)) {
            DeferredRegister.Blocks deferredBlockRegister = DeferredRegister.createBlocks((String)namespace);
            deferredBlockRegisterMap.put(namespace, deferredBlockRegister);
        }
        DeferredBlock deferredBlockObject = deferredBlockRegisterMap.get(namespace).registerBlock(resourceLocation.getPath(), blockFunction, properties);
        if (registerAsItem) {
            DeferredItem<Item> deferredItemObject = NeoForgeRegisterItemHelper.staticRegisterItem(modEventBusObject, resourceLocation, itemProperties -> new BlockItem((Block)deferredBlockObject.get(), itemProperties), new Item.Properties().useBlockDescriptionPrefix(), creativeModeTabResourceKey, lastBlock);
            registeredBlockWithItemPairs.put(resourceLocation, (Pair<DeferredBlock<Block>, DeferredItem<Item>>)Pair.of((Object)deferredBlockObject, deferredItemObject));
        } else {
            registeredBlocksWithoutItem.put(resourceLocation, (DeferredBlock<Block>)deferredBlockObject);
        }
        if (lastBlock) {
            deferredBlockRegisterMap.get(namespace).register((IEventBus)modEventBusObject);
        }
    }
}

