/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.natamus.collective_common_fabric.data.Constants;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class PlayerFunctions {
    public static boolean respawnPlayer(class_1937 world, class_1657 player) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverplayer = (class_3222)player;
        MinecraftServer server = world.method_8503();
        if (serverplayer.field_13989) {
            serverplayer.field_13989 = false;
            serverplayer = server.method_3760().method_14556(serverplayer, true, class_1297.class_5529.field_27002);
            class_174.field_1183.method_8794(serverplayer, class_1937.field_25181, class_1937.field_25179);
        } else if (serverplayer.method_6032() <= 0.0f) {
            server.method_3760().method_14556(serverplayer, false, class_1297.class_5529.field_26998);
        }
        return true;
    }

    public static class_1657 matchPlayer(class_1657 player, String other) {
        return PlayerFunctions.matchPlayer(player.method_73183(), other);
    }

    public static class_1657 matchPlayer(class_1937 world, String other) {
        List players = world.method_18456();
        for (class_1657 onlineplayer : players) {
            if (!onlineplayer.method_5477().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(class_1657 player) {
        return player.method_5998(class_1268.field_5810).method_7909().equals(class_1802.field_8705) || player.method_5998(class_1268.field_5808).method_7909().equals(class_1802.field_8705);
    }

    public static boolean isJoiningWorldForTheFirstTime(class_1657 player, String modid) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false);
    }

    public static boolean isJoiningWorldForTheFirstTime(class_1657 player, String modid, boolean mustHaveEmptyInventory) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false, true);
    }

    public static boolean isJoiningWorldForTheFirstTime(class_1657 player, String modid, boolean mustHaveEmptyInventory, boolean mustBeCloseToSpawn) {
        String firstjointag = "collective.firstJoin." + modid;
        String playerName = player.method_5477().getString();
        Set tags = player.method_5752();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.method_5780(firstjointag);
        if (mustHaveEmptyInventory) {
            class_1661 inv = player.method_31548();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                if (inv.method_5438(i).method_7960()) continue;
                isempty = false;
                break;
            }
            if (!isempty) {
                Constants.LOG.debug("[{}] Inventory of {} is not empty, first join is false.", (Object)modid, (Object)playerName);
                return false;
            }
        }
        if (mustBeCloseToSpawn) {
            class_1937 level = player.method_73183();
            class_3218 serverLevel = (class_3218)level;
            class_3222 serverPlayer = (class_3222)player;
            class_5217.class_12064 respawnData = serverLevel.method_74854();
            class_4208 globalSpawnPos = respawnData.comp_4915();
            class_5321 spawnDimension = globalSpawnPos.comp_2207();
            class_2338 spawnPos = globalSpawnPos.comp_2208();
            class_3222.class_10766 respawnConfig = serverPlayer.method_67564();
            if (respawnConfig != null) {
                class_5217.class_12064 respawnConfigRespawnData = respawnConfig.comp_4913();
                spawnDimension = respawnConfigRespawnData.method_74894();
                spawnPos = respawnConfigRespawnData.method_74897();
            }
            Constants.LOG.debug("[{}] Checking for first join of {} with spawn position: {}", new Object[]{modid, playerName, spawnPos.method_23854()});
            if (!spawnDimension.equals(player.method_73183().method_27983())) {
                return false;
            }
            class_2338 playerPos = player.method_24515();
            class_2338 checkPos = new class_2338(playerPos.method_10263(), spawnPos.method_10264(), playerPos.method_10260());
            int spawnRadius = ((class_1928.class_4312)serverLevel.method_64395().method_20746(class_1928.field_19403)).method_20763();
            Constants.LOG.debug("[{}] Checking for first join of {} with spawn radius: {}", new Object[]{modid, playerName, spawnRadius});
            return checkPos.method_19771((class_2382)spawnPos, (double)(spawnRadius * 2));
        }
        return true;
    }

    public static class_2338 getSpawnPoint(class_1937 level, class_1657 player) {
        class_243 spawnvec = PlayerFunctions.getSpawnVec(level, player);
        return class_2338.method_49637((double)spawnvec.field_1352, (double)spawnvec.field_1351, (double)spawnvec.field_1350);
    }

    public static class_243 getSpawnVec(class_1937 level, class_1657 player) {
        class_3222 serverplayer = (class_3222)player;
        class_3218 serverLevel = (class_3218)level;
        class_5217.class_12064 respawnData = serverLevel.method_74854();
        class_4208 globalRespawnPos = respawnData.comp_4915();
        class_2338 respawnlocation = globalRespawnPos.comp_2208();
        class_243 respawnvec = new class_243((double)respawnlocation.method_10263(), (double)respawnlocation.method_10264(), (double)respawnlocation.method_10260());
        class_2338 bedpos = serverplayer.method_67564().comp_4913().method_74897();
        if (bedpos != null) {
            class_5454 optionalbed = ((class_3222)player).method_60590(true, class_5454.field_52245);
            class_243 bedvec = optionalbed.comp_2821();
            class_2338 bp = class_2338.method_49638((class_2374)bedvec);
            Iterator it = class_2338.method_17962((int)(bp.method_10263() - 1), (int)(bp.method_10264() - 1), (int)(bp.method_10260() - 1), (int)(bp.method_10263() + 1), (int)(bp.method_10264() + 1), (int)(bp.method_10260() + 1)).iterator();
            while (it.hasNext()) {
                class_2338 np = (class_2338)it.next();
                class_2680 state = level.method_8320(np);
                class_2248 block = state.method_26204();
                if (!(block instanceof class_2244)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static class_1268 getOtherHand(class_1268 hand) {
        if (hand.equals((Object)class_1268.field_5808)) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    public static String getPlayerGearString(class_1657 player) {
        class_1937 level = player.method_73183();
        StringBuilder skconfig = new StringBuilder();
        class_1799 offhand = player.method_6118(class_1304.field_6171);
        if (!offhand.method_7960()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, offhand);
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        class_1799 head = player.method_6118(class_1304.field_6169);
        if (!head.method_7960()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, head);
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        class_1799 chest = player.method_6118(class_1304.field_6174);
        if (!chest.method_7960()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, chest);
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        class_1799 legs = player.method_6118(class_1304.field_6172);
        if (!legs.method_7960()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, legs);
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        class_1799 feet = player.method_6118(class_1304.field_6166);
        if (!feet.method_7960()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, feet);
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        class_1661 inv = player.method_31548();
        for (int i = 0; i < 36; ++i) {
            class_1799 slot = inv.method_5438(i);
            if (!slot.method_7960()) {
                String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, slot);
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(class_1937 level, HashMap<String, class_1799> gear) {
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                specialslotstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get(specialslot));
            }
            if (!gearstring.toString().isEmpty()) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        class_2371 emptyinventory = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                itemstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get("" + i));
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void setPlayerGearFromString(class_1657 player, String gearconfig) {
        class_1937 level = player.method_73183();
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String string : gearspl) {
            class_1304 type;
            void var9_9;
            String[] lspl;
            void var9_13;
            String string2 = string.trim();
            if (string2.endsWith(",")) {
                String string3 = string2.substring(0, string2.length() - 1);
            }
            if (!var9_13.endsWith("'")) {
                String string4 = (String)var9_13 + "'";
            }
            if ((lspl = var9_9.split(" : ")).length != 2) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The line {} is invalid.", (Object)var9_9);
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            class_1799 itemStack = class_1799.field_8037;
            try {
                class_2487 compoundTag2 = class_2522.method_67315((String)data);
                itemStack = class_1799.field_24671.parse((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag2).result().orElse(class_1799.field_8037);
            }
            catch (CommandSyntaxException compoundTag2) {
                // empty catch block
            }
            if (itemStack.method_7960()) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    class_2487 compoundTag = class_2522.method_67315((String)data);
                    itemStack = class_1799.field_24671.parse((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag).result().orElse(class_1799.field_8037);
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (itemStack.method_7960()) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data {}", (Object)data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.method_31548().method_5448();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.method_31548().method_5447(slot, itemStack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = class_1304.field_6171;
                    break;
                }
                case "head": {
                    type = class_1304.field_6169;
                    break;
                }
                case "chest": {
                    type = class_1304.field_6174;
                    break;
                }
                case "legs": {
                    type = class_1304.field_6172;
                    break;
                }
                case "feet": {
                    type = class_1304.field_6166;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            player.method_5673(type, itemStack);
        }
    }
}

