/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.data.Constants;
import com.natamus.collective_common_fabric.schematic.SchematicBlockObject;
import com.natamus.collective_common_fabric.schematic.SchematicFunctions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<class_2487> blockEntities;
    private List<Pair<class_2338, class_2487>> entities;
    private boolean parsedCorrectly = false;

    public Schematic(InputStream inputStream) {
        new Schematic(inputStream, null);
    }

    public Schematic(InputStream inputStream, class_1937 level) {
        class_7922 blockRegistry = class_7923.field_41175;
        if (level != null) {
            blockRegistry = level.method_30349().method_30530(class_7924.field_41254);
        }
        String type = "";
        try {
            class_2487 nbtdata = SchematicFunctions.readCompressed(inputStream);
            inputStream.close();
            if (nbtdata.method_10545("Schematic")) {
                nbtdata = nbtdata.method_68568("Schematic");
            }
            if (nbtdata.method_10545("Length")) {
                this.width = (Short)nbtdata.method_10568("Width").get();
                this.height = (Short)nbtdata.method_10568("Height").get();
                this.length = (Short)nbtdata.method_10568("Length").get();
            } else {
                class_2499 sizeList = (class_2499)nbtdata.method_10554("size").get();
                this.width = (Short)sizeList.method_10609(0).get();
                this.height = (Short)sizeList.method_10609(1).get();
                this.length = (Short)sizeList.method_10609(2).get();
            }
            this.size = this.width * this.height * this.length;
            type = nbtdata.method_10545("entities") ? "nbt" : (nbtdata.method_10545("DataVersion") ? "schem" : "schematic");
            this.blockObjects = new SchematicBlockObject[this.size];
            this.entities = new ArrayList<Pair<class_2338, class_2487>>();
            switch (type) {
                case "schem": {
                    class_2499 tileentitynbtlist;
                    class_2487 palette;
                    byte[] blockDataRaw;
                    int[] blockData = new int[this.width * this.height * this.length];
                    if (nbtdata.method_68083("Version", 2) == 2) {
                        blockDataRaw = (byte[])nbtdata.method_10547("BlockData").get();
                        palette = (class_2487)nbtdata.method_10562("Palette").get();
                        tileentitynbtlist = (class_2499)nbtdata.method_10554("BlockEntities").get();
                        class_2487 offsetCompoundTag = (class_2487)nbtdata.method_10562("Metadata").get();
                        this.offsetX = (Integer)offsetCompoundTag.method_10550("WEOffsetX").get();
                        this.offsetY = (Integer)offsetCompoundTag.method_10550("WEOffsetY").get();
                        this.offsetZ = (Integer)offsetCompoundTag.method_10550("WEOffsetZ").get();
                    } else {
                        class_2487 blocksCompoundTag = nbtdata.method_68568("Blocks");
                        blockDataRaw = (byte[])blocksCompoundTag.method_10547("Data").get();
                        palette = (class_2487)blocksCompoundTag.method_10562("Palette").get();
                        tileentitynbtlist = (class_2499)blocksCompoundTag.method_10554("BlockEntities").get();
                        int[] offsetArray = (int[])nbtdata.method_10561("Offset").get();
                        this.offsetX = offsetArray[0];
                        this.offsetY = offsetArray[1];
                        this.offsetZ = offsetArray[2];
                    }
                    int index = 0;
                    int i = 0;
                    while (i < blockDataRaw.length) {
                        int value = 0;
                        int varintLength = 0;
                        while (true) {
                            value |= (blockDataRaw[i] & 0x7F) << varintLength++ * 7;
                            if (varintLength > 5) continue;
                            if ((blockDataRaw[i] & 0x80) != 128) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        blockData[index] = value;
                        ++index;
                    }
                    this.palette = new HashMap();
                    for (String k : palette.method_10541()) {
                        this.palette.put((Integer)palette.method_10550(k).get(), k);
                    }
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                class_2338 pos = new class_2338(x, y, z);
                                int id = blockData[counter];
                                if (id < 0) {
                                    id *= -1;
                                }
                                class_2680 state = this.getStateFromID((class_2378<class_2248>)blockRegistry, id);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    this.blockEntities = new ArrayList<class_2487>();
                    for (int t = 0; t < tileentitynbtlist.size(); ++t) {
                        this.blockEntities.add((class_2487)tileentitynbtlist.method_10602(t).get());
                    }
                    this.parsedCorrectly = true;
                    return;
                }
                case "schematic": {
                    byte[] blockIDs_byte = (byte[])nbtdata.method_10547("Blocks").get();
                    int[] blockIDs = new int[this.size];
                    for (int x = 0; x < blockIDs_byte.length; ++x) {
                        blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                    }
                    byte[] metadata = (byte[])nbtdata.method_10547("Data").get();
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                class_2338 pos = new class_2338(x, y, z);
                                class_2680 state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    class_2499 tileentitynbtlist = (class_2499)nbtdata.method_10554("TileEntities").get();
                    this.blockEntities = new ArrayList<class_2487>();
                    for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                        class_2487 compound = (class_2487)tileentitynbtlist.method_10602(i).get();
                        int i0 = (Integer)compound.method_10550("x").get();
                        int i1 = (Integer)compound.method_10550("y").get();
                        int i2 = (Integer)compound.method_10550("z").get();
                        compound.method_10539("Pos", new int[]{i0, i1, i2});
                        this.blockEntities.add(compound);
                    }
                    this.offsetX = (Integer)nbtdata.method_10550("WEOffsetX").get();
                    this.offsetY = (Integer)nbtdata.method_10550("WEOffsetY").get();
                    this.offsetZ = (Integer)nbtdata.method_10550("WEOffsetZ").get();
                    this.parsedCorrectly = true;
                    return;
                }
                case "nbt": {
                    class_2499 paletteNBTList = (class_2499)nbtdata.method_10554("palette").get();
                    this.palette = new HashMap();
                    for (int i = 0; i < paletteNBTList.size(); ++i) {
                        class_2487 compound = (class_2487)paletteNBTList.method_10602(i).get();
                        Object value = (String)compound.method_10558("Name").get();
                        if (compound.method_10545("Properties")) {
                            StringBuilder metaData = new StringBuilder("[");
                            class_2487 propertyCompound = (class_2487)compound.method_10562("Properties").get();
                            for (String propertyKey : propertyCompound.method_10541()) {
                                if (!metaData.toString().equals("[")) {
                                    metaData.append(",");
                                }
                                metaData.append(propertyKey).append("=").append(propertyCompound.method_10580(propertyKey));
                            }
                            metaData.append("]");
                            value = (String)value + String.valueOf(metaData);
                        }
                        this.palette.put(i, (String)value);
                    }
                    this.blockEntities = new ArrayList<class_2487>();
                    class_2499 blocksNBTList = (class_2499)nbtdata.method_10554("blocks").get();
                    for (int i = 0; i < blocksNBTList.size(); ++i) {
                        class_2487 compound = (class_2487)blocksNBTList.method_10602(i).get();
                        class_2499 posList = (class_2499)compound.method_10554("pos").get();
                        int i0 = (Integer)posList.method_10600(0).get();
                        int i1 = (Integer)posList.method_10600(1).get();
                        int i2 = (Integer)posList.method_10600(2).get();
                        class_2338 pos = new class_2338(i0, i1, i2);
                        class_2680 state = this.getStateFromID((class_2378<class_2248>)blockRegistry, (Integer)compound.method_10550("state").get());
                        this.blockObjects[i] = new SchematicBlockObject(pos, state);
                        if (!compound.method_10545("nbt")) continue;
                        class_2487 blockEntityCompound = (class_2487)compound.method_10562("nbt").get();
                        blockEntityCompound.method_10539("Pos", new int[]{i0, i1, i2});
                        blockEntityCompound.method_10582("Id", (String)blockEntityCompound.method_10558("id").get());
                        blockEntityCompound.method_10551("id");
                        this.blockEntities.add(blockEntityCompound);
                    }
                    class_2499 entitiesNBTList = (class_2499)nbtdata.method_10554("entities").get();
                    for (int i = 0; i < entitiesNBTList.size(); ++i) {
                        class_2487 compound = (class_2487)entitiesNBTList.method_10602(i).get();
                        class_2487 entityCompound = (class_2487)compound.method_10562("nbt").get();
                        class_2499 posList = (class_2499)compound.method_10554("blockPos").get();
                        int i0 = (Integer)posList.method_10600(0).get();
                        int i1 = (Integer)posList.method_10600(1).get();
                        int i2 = (Integer)posList.method_10600(2).get();
                        this.entities.add((Pair<class_2338, class_2487>)new Pair((Object)new class_2338(i0, i1, i2), (Object)entityCompound));
                    }
                    this.offsetX = 0;
                    this.offsetY = 0;
                    this.offsetZ = 0;
                    this.parsedCorrectly = true;
                    return;
                }
            }
        }
        catch (Exception ignored) {
            Constants.LOG.warn("[Collective] Something went wrong while parsing the schematic.");
        }
        Constants.LOG.warn("Can't load {} Schematic file.", (Object)type);
        this.width = 0;
        this.height = 0;
        this.length = 0;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        this.size = 0;
        this.blockObjects = null;
        this.palette = null;
        this.blockEntities = null;
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private class_2680 getStateFromOldIds(int blockID, byte meta) {
        return class_2248.method_9531((int)blockID);
    }

    public class_2680 getBlockState(class_2338 pos) {
        for (SchematicBlockObject schematicBlockObject : this.blockObjects) {
            if (!schematicBlockObject.getPosition().equals((Object)pos)) continue;
            return schematicBlockObject.getState();
        }
        return class_2246.field_10124.method_9564();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public class_2680 getStateFromID(class_2378<class_2248> blockRegistry, int id) {
        String iblockstateS = this.palette.get(id);
        try {
            return class_2259.method_41955(blockRegistry, (StringReader)new StringReader(iblockstateS), (boolean)false).comp_622();
        }
        catch (Exception ex) {
            return class_2246.field_10124.method_9564();
        }
    }

    public List<class_2487> getBlockEntities() {
        return this.blockEntities;
    }

    public List<Pair<class_2338, class_2487>> getEntityRelativePosPairs() {
        return this.entities;
    }

    public class_2487 getTileEntity(class_2338 pos) {
        for (class_2487 compound : this.blockEntities) {
            int[] pos1 = (int[])compound.method_10561("Pos").get();
            if (pos1[0] != pos.method_10263() || pos1[1] != pos.method_10264() || pos1[2] != pos.method_10260()) continue;
            return compound;
        }
        return null;
    }

    public class_2338 getBlockPosFromCompoundTag(class_2487 compoundTag) {
        int[] pos = (int[])compoundTag.method_10561("Pos").get();
        return new class_2338(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean wasParsedCorrectly() {
        return this.parsedCorrectly;
    }
}

