/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.api.variables;

import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.api.variables.validation.UnsafeSupplier;
import com.hypherionmc.simplerpc.api.variables.validation.Validator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class PlaceholderEngine {
    public static final PlaceholderEngine INSTANCE = new PlaceholderEngine();
    private final HashMap<String, Variable> placeholders = new LinkedHashMap<String, Variable>();
    private final Pattern placeholderPattern = Pattern.compile("\\{\\{\\s*([\\w.]+)\\s*\\}\\}");
    private final Validator EMPTY = () -> true;

    public void registerPlaceholder(String holder, String defaultValue, UnsafeSupplier<String> resolver) {
        this.registerPlaceholder(holder, this.EMPTY, defaultValue, resolver);
    }

    public void registerPlaceholder(String holder, Validator validator, String defaultValue, UnsafeSupplier<String> resolver) {
        if (this.placeholders.containsKey(holder)) {
            throw new RuntimeException("Tried to register duplicate RPC Variable " + holder);
        }
        this.placeholders.put(holder, new Variable(holder, defaultValue, resolver, validator));
    }

    public String resolvePlaceholders(String inputString) {
        Matcher matcher = this.placeholderPattern.matcher(inputString);
        while (matcher.find()) {
            String key = matcher.group(1);
            Variable replacement = this.placeholders.get(key);
            if (replacement != null) {
                inputString = inputString.replace(matcher.group(0), replacement.resolve());
                continue;
            }
            inputString = inputString.replace(matcher.group(0), "Unknown Placeholder");
        }
        return inputString;
    }

    public void clear() {
        this.placeholders.clear();
    }

    @Generated
    private PlaceholderEngine() {
    }

    record Variable(String holder, String defaultValue, UnsafeSupplier<String> resolver, Validator validator) {
        String resolve() {
            if (!this.validator().validate()) {
                return this.defaultValue;
            }
            try {
                String val = this.resolver.get();
                return val == null ? this.defaultValue : val;
            }
            catch (Exception e) {
                RPCConstants.logger.error("Failed to parse placeholder {}: {}", (Object)this.holder, (Object)e);
                return this.defaultValue;
            }
        }
    }
}

