/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;

public class ByteConverter
implements TypeConverter<Byte> {
    @Override
    public Byte convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Byte.class) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar(stringValue, '+')) {
                stringValue = stringValue.substring(1);
            }
            return Byte.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

