/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog.filter;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.actionlog.filter.ActionFields;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.ConstraintFactory;
import me.lucko.luckperms.common.filter.FilterList;
import net.luckperms.api.actionlog.Action;

public final class ActionFilters {
    private static final ConstraintFactory<Action.Target.Type> TARGET_TYPE_CONSTRAINT_FACTORY = new ConstraintFactory<Action.Target.Type>(){

        @Override
        public Predicate<Action.Target.Type> equal(Action.Target.Type value) {
            return value::equals;
        }

        @Override
        public Predicate<Action.Target.Type> notEqual(Action.Target.Type value) {
            return string -> !value.equals(string);
        }

        @Override
        public Predicate<Action.Target.Type> similar(Action.Target.Type value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value.toString());
            return type -> pattern.matcher(type.toString()).matches();
        }

        @Override
        public Predicate<Action.Target.Type> notSimilar(Action.Target.Type value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value.toString());
            return type -> !pattern.matcher(type.toString()).matches();
        }
    };

    private ActionFilters() {
    }

    public static FilterList<Action> all() {
        return FilterList.empty();
    }

    public static FilterList<Action> source(UUID uniqueId) {
        return FilterList.and(ActionFields.SOURCE_UNIQUE_ID.isEqualTo(uniqueId, ConstraintFactory.UUIDS));
    }

    public static FilterList<Action> user(UUID uniqueId) {
        return FilterList.and(ActionFields.TARGET_TYPE.isEqualTo(Action.Target.Type.USER, TARGET_TYPE_CONSTRAINT_FACTORY), ActionFields.TARGET_UNIQUE_ID.isEqualTo(uniqueId, ConstraintFactory.UUIDS));
    }

    public static FilterList<Action> group(String name) {
        return FilterList.and(ActionFields.TARGET_TYPE.isEqualTo(Action.Target.Type.GROUP, TARGET_TYPE_CONSTRAINT_FACTORY), ActionFields.TARGET_NAME.isEqualTo(name, ConstraintFactory.STRINGS));
    }

    public static FilterList<Action> track(String name) {
        return FilterList.and(ActionFields.TARGET_TYPE.isEqualTo(Action.Target.Type.TRACK, TARGET_TYPE_CONSTRAINT_FACTORY), ActionFields.TARGET_NAME.isEqualTo(name, ConstraintFactory.STRINGS));
    }

    public static FilterList<Action> search(String query) {
        return FilterList.or(ActionFields.SOURCE_NAME.isSimilarTo("%" + query + "%", ConstraintFactory.STRINGS), ActionFields.TARGET_NAME.isSimilarTo("%" + query + "%", ConstraintFactory.STRINGS), ActionFields.DESCRIPTION.isSimilarTo("%" + query + "%", ConstraintFactory.STRINGS));
    }
}

