/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.result;

import me.lucko.luckperms.common.cacheddata.result.AbstractResult;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import net.luckperms.api.node.Node;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TristateResult
extends AbstractResult<Tristate, Node, TristateResult> {
    private final Tristate result;
    private final Class<? extends PermissionProcessor> processorClass;
    private static final TristateResult TRUE = new TristateResult(Tristate.TRUE, null, null);
    private static final TristateResult FALSE = new TristateResult(Tristate.FALSE, null, null);
    public static final TristateResult UNDEFINED = new TristateResult(Tristate.UNDEFINED, null, null);

    private TristateResult(Tristate result, Node node, Class<? extends PermissionProcessor> processorClass) {
        super(node, null);
        this.result = result;
        this.processorClass = processorClass;
    }

    @Override
    public @NonNull Tristate result() {
        return this.result;
    }

    public @Nullable Class<? extends PermissionProcessor> processorClass() {
        return this.processorClass;
    }

    public @Nullable String processorClassFriendly() {
        if (this.processorClass == null) {
            return null;
        }
        if (this.processorClass.getName().startsWith("me.lucko.luckperms.")) {
            String simpleName = this.processorClass.getSimpleName();
            String platform = this.processorClass.getName().split("\\.")[3];
            return platform + "." + simpleName;
        }
        return this.processorClass.getName();
    }

    public String toString() {
        return "TristateResult(result=" + String.valueOf((Object)this.result) + ", node=" + String.valueOf(this.node) + ", processorClass=" + String.valueOf(this.processorClass) + ", overriddenResult=" + String.valueOf(this.overriddenResult) + ")";
    }

    public static TristateResult forMonitoredResult(Tristate result) {
        switch (result) {
            case TRUE: {
                return TRUE;
            }
            case FALSE: {
                return FALSE;
            }
            case UNDEFINED: {
                return UNDEFINED;
            }
        }
        throw new AssertionError();
    }

    public static final class Factory {
        private final Class<? extends PermissionProcessor> processorClass;

        public Factory(Class<? extends PermissionProcessor> processorClass) {
            this.processorClass = processorClass;
        }

        public TristateResult result(Tristate result) {
            switch (result) {
                case TRUE: 
                case FALSE: {
                    return new TristateResult(result, null, this.processorClass);
                }
                case UNDEFINED: {
                    return UNDEFINED;
                }
            }
            throw new AssertionError();
        }

        public TristateResult result(@Nullable Node node) {
            if (node == null) {
                return UNDEFINED;
            }
            return new TristateResult(Tristate.of(node.getValue()), node, this.processorClass);
        }

        public TristateResult resultWithOverride(@Nullable Node node, @NonNull Tristate result) {
            if (result == Tristate.UNDEFINED) {
                return UNDEFINED;
            }
            return new TristateResult(result, node, this.processorClass);
        }
    }
}

