/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.calculator.processor;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.calculator.processor.AbstractSourceBasedProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import net.luckperms.api.node.Node;
import net.luckperms.api.util.Tristate;

public class WildcardProcessor
extends AbstractSourceBasedProcessor
implements PermissionProcessor {
    private static final TristateResult.Factory RESULT_FACTORY = new TristateResult.Factory(WildcardProcessor.class);
    public static final String WILDCARD_SUFFIX = ".*";
    private static final String ROOT_WILDCARD = "*";
    private static final String ROOT_WILDCARD_WITH_QUOTES = "'*'";
    private Map<String, TristateResult> wildcardPermissions = Collections.emptyMap();
    private TristateResult rootWildcardState = TristateResult.UNDEFINED;

    public static boolean isRootWildcard(String permission) {
        return ROOT_WILDCARD.equals(permission) || ROOT_WILDCARD_WITH_QUOTES.equals(permission);
    }

    public static boolean isWildcardPermission(String permission) {
        return WildcardProcessor.isRootWildcard(permission) || permission.endsWith(WILDCARD_SUFFIX) && permission.length() > 2;
    }

    @Override
    public TristateResult hasPermission(String permission) {
        int endIndex;
        String node = permission;
        while ((endIndex = node.lastIndexOf(46)) != -1) {
            TristateResult match;
            if ((node = node.substring(0, endIndex)).isEmpty() || (match = this.wildcardPermissions.get(node)) == null || match.result() == Tristate.UNDEFINED) continue;
            return match;
        }
        return this.rootWildcardState;
    }

    @Override
    public void refresh() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.sourceMap.entrySet()) {
            String key = (String)e.getKey();
            if (!key.endsWith(WILDCARD_SUFFIX) || key.length() <= 2) continue;
            key = key.substring(0, key.length() - 2);
            TristateResult value = RESULT_FACTORY.result((Node)e.getValue());
            builder.put((Object)key, (Object)value);
        }
        this.wildcardPermissions = builder.build();
        Node rootWildcard = (Node)this.sourceMap.get(ROOT_WILDCARD);
        if (rootWildcard == null) {
            rootWildcard = (Node)this.sourceMap.get(ROOT_WILDCARD_WITH_QUOTES);
        }
        this.rootWildcardState = rootWildcard == null ? TristateResult.UNDEFINED : RESULT_FACTORY.result(rootWildcard);
    }
}

