/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.permission;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.node.types.RegexPermissionNode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;

public class PermissionCheck
extends GenericChildCommand {
    public PermissionCheck() {
        super(CommandSpec.PERMISSION_CHECK, "check", CommandPermission.USER_PERM_CHECK, CommandPermission.GROUP_PERM_CHECK, Predicates.is(0));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        String origin;
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String node = args.get(0);
        if (node.isEmpty()) {
            Message.INVALID_PERMISSION_EMPTY.send(sender);
            return;
        }
        ArrayList<Node> own = new ArrayList<Node>();
        ArrayList<Node> inherited = new ArrayList<Node>();
        ArrayList<Node> wildcards = new ArrayList<Node>();
        List<Node> resolved = target.resolveInheritedNodes(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        for (Node n : resolved) {
            if (PermissionCheck.matches(node, n, plugin)) {
                if (PermissionCheck.isInherited(n, target)) {
                    inherited.add(n);
                } else {
                    own.add(n);
                }
            }
            if (!PermissionCheck.matchesWildcard(node, n, plugin)) continue;
            wildcards.add(n);
        }
        Message.PERMISSION_CHECK_INFO_HEADER.send(sender, node);
        if (own.isEmpty()) {
            Message.PERMISSION_CHECK_INFO_NOT_DIRECTLY.send(sender, target, node);
        } else {
            for (Node n : own) {
                Message.PERMISSION_CHECK_INFO_DIRECTLY.send(sender, target, n.getKey(), Tristate.of(n.getValue()), n.getContexts());
            }
        }
        if (inherited.isEmpty()) {
            Message.PERMISSION_CHECK_INFO_NOT_INHERITED.send(sender, target, node);
        } else {
            for (Node n : inherited) {
                origin = n.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName();
                Message.PERMISSION_CHECK_INFO_INHERITED.send(sender, target, n.getKey(), Tristate.of(n.getValue()), n.getContexts(), origin);
            }
        }
        for (Node n : wildcards) {
            if (PermissionCheck.isInherited(n, target)) {
                origin = n.metadata(InheritanceOriginMetadata.KEY).getOrigin().getName();
                Message.PERMISSION_CHECK_INFO_INHERITED.send(sender, target, n.getKey(), Tristate.of(n.getValue()), n.getContexts(), origin);
                continue;
            }
            Message.PERMISSION_CHECK_INFO_DIRECTLY.send(sender, target, n.getKey(), Tristate.of(n.getValue()), n.getContexts());
        }
        sender.sendMessage((Component)Message.prefixed((ComponentLike)Component.empty()));
        QueryOptions queryOptions = target.getQueryOptions();
        TristateResult checkResult = target.getCachedData().getPermissionData(queryOptions).checkPermission(node, CheckOrigin.INTERNAL);
        Tristate result = checkResult.result();
        String processor = checkResult.processorClassFriendly();
        Object cause = checkResult.node();
        ImmutableContextSet context = queryOptions.context();
        Message.PERMISSION_CHECK_RESULT.send(sender, node, result, processor, (Node)cause, context);
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).complete((List<String>)((Object)args));
    }

    private static boolean isInherited(Node n, PermissionHolder target) {
        PermissionHolder.Identifier origin = n.getMetadata(InheritanceOriginMetadata.KEY).map(InheritanceOriginMetadata::getOrigin).orElse(null);
        return origin != null && !target.getIdentifier().equals(origin);
    }

    private static boolean matchesWildcard(String permission, Node node, LuckPermsPlugin plugin) {
        String wildcardBody;
        int endIndex;
        String key;
        if (plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS).booleanValue() && node instanceof PermissionNode && ((PermissionNode)node).isWildcard()) {
            key = node.getKey();
            if (WildcardProcessor.isRootWildcard(key)) {
                return true;
            }
            String wildcardBody2 = key.substring(0, key.length() - 1);
            if (permission.startsWith(wildcardBody2)) {
                return true;
            }
        }
        return plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS_SPONGE) != false && (endIndex = (key = node.getKey()).lastIndexOf(46)) > 0 && permission.startsWith(wildcardBody = key.substring(0, endIndex));
    }

    private static boolean matches(String permission, Node node, LuckPermsPlugin plugin) {
        Pattern pattern;
        if (node.getKey().equals(permission)) {
            return true;
        }
        if (plugin.getConfiguration().get(ConfigKeys.APPLYING_SHORTHAND).booleanValue() && node.resolveShorthand().contains(permission)) {
            return true;
        }
        return plugin.getConfiguration().get(ConfigKeys.APPLYING_REGEX) != false && node instanceof RegexPermissionNode && (pattern = (Pattern)((RegexPermissionNode)node).getPattern().orElse(null)) != null && pattern.matcher(permission).matches();
    }
}

