/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;

public class ListGroups
extends SingleCommand {
    public ListGroups() {
        super(CommandSpec.LIST_GROUPS, "ListGroups", CommandPermission.LIST_GROUPS, Predicates.notInRange(0, 1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        try {
            plugin.getStorage().loadAllGroups().get();
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst loading groups", e);
            Message.GROUPS_LOAD_ERROR.send(sender);
            return;
        }
        int page = args.getIntOrDefault(0, 1);
        int pageIndex = page - 1;
        List groups = plugin.getGroupManager().getAll().values().stream().sorted((o1, o2) -> {
            int i = Integer.compare(o2.getWeight().orElse(0), o1.getWeight().orElse(0));
            return i != 0 ? i : o1.getName().compareToIgnoreCase(o2.getName());
        }).collect(Collectors.toList());
        List pages = Iterators.divideIterable(groups, 8);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        Message.SEARCH_SHOWING_GROUPS.send(sender, page, pages.size(), groups.size());
        Message.GROUPS_LIST.send(sender);
        Collection allTracks = plugin.getTrackManager().getAll().values();
        for (Group group : pages.get(pageIndex)) {
            List tracks = allTracks.stream().filter(t -> t.containsGroup(group)).map(Track::getName).collect(Collectors.toList());
            Message.GROUPS_LIST_ENTRY.send(sender, group, group.getWeight().orElse(0), tracks);
        }
    }
}

