/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LogPage;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.actionlog.filter.ActionFilters;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;

public class LogGroupHistory
extends ChildCommand<Void> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogGroupHistory() {
        super(CommandSpec.LOG_GROUP_HISTORY, "grouphistory", CommandPermission.LOG_GROUP_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Void ignored, ArgumentList args, String label) {
        String group = args.get(0).toLowerCase(Locale.ROOT);
        if (!DataConstraints.GROUP_NAME_TEST.test(group)) {
            Message.GROUP_INVALID_ENTRY.send(sender, group);
            return;
        }
        PageParameters pageParams = new PageParameters(10, args.getIntOrDefault(1, 1));
        LogPage log = plugin.getStorage().getLogPage(ActionFilters.group(group), pageParams).join();
        int page = pageParams.pageNumber();
        int maxPage = pageParams.getMaxPage(log.getTotalEntries());
        if (log.getTotalEntries() == 0) {
            Message.LOG_NO_ENTRIES.send(sender);
            return;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return;
        }
        List<LogPage.Entry<LoggedAction>> entries = log.getNumberedContent();
        String name = ((LoggedAction)((LogPage.Entry)entries.stream().findAny().get()).value()).getTarget().getName();
        Message.LOG_HISTORY_GROUP_HEADER.send(sender, name, page, maxPage);
        for (LogPage.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), e.value());
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete((List<String>)((Object)args));
    }
}

