/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.types.Permission;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class LogNotify
extends ChildCommand<Void> {
    private static final String IGNORE_NODE = "luckperms.log.notify.ignoring";

    public LogNotify() {
        super(CommandSpec.LOG_NOTIFY, "notify", CommandPermission.LOG_NOTIFY, Predicates.notInRange(0, 1));
    }

    public static boolean isIgnoring(LuckPermsPlugin plugin, UUID uuid) {
        User user = (User)plugin.getUserManager().getIfLoaded(uuid);
        if (user == null) {
            return false;
        }
        Optional<Node> node = user.normalData().nodesInContext(ImmutableContextSetImpl.EMPTY).stream().filter(n -> n.getKey().equalsIgnoreCase(IGNORE_NODE)).findFirst();
        return node.map(Node::getValue).orElse(false);
    }

    private static void setIgnoring(LuckPermsPlugin plugin, UUID uuid, boolean state) {
        User user = (User)plugin.getUserManager().getIfLoaded(uuid);
        if (user == null) {
            return;
        }
        if (state) {
            user.setNode(DataType.NORMAL, (Node)Permission.builder().permission(IGNORE_NODE).build(), true);
        } else {
            user.removeIf(DataType.NORMAL, ImmutableContextSetImpl.EMPTY, n -> n.getKey().equalsIgnoreCase(IGNORE_NODE), false);
        }
        plugin.getStorage().saveUser(user).join();
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Void ignored, ArgumentList args, String label) {
        if (sender.isConsole()) {
            Message.LOG_NOTIFY_CONSOLE.send(sender);
            return;
        }
        UUID uuid = sender.getUniqueId();
        if (args.isEmpty()) {
            if (LogNotify.isIgnoring(plugin, uuid)) {
                LogNotify.setIgnoring(plugin, uuid, false);
                Message.LOG_NOTIFY_TOGGLE_ON.send(sender);
                return;
            }
            LogNotify.setIgnoring(plugin, uuid, true);
            Message.LOG_NOTIFY_TOGGLE_OFF.send(sender);
            return;
        }
        if (args.get(0).equalsIgnoreCase("on")) {
            if (!LogNotify.isIgnoring(plugin, uuid)) {
                Message.LOG_NOTIFY_ALREADY_ON.send(sender);
                return;
            }
            LogNotify.setIgnoring(plugin, uuid, false);
            Message.LOG_NOTIFY_TOGGLE_ON.send(sender);
            return;
        }
        if (args.get(0).equalsIgnoreCase("off")) {
            if (LogNotify.isIgnoring(plugin, uuid)) {
                Message.LOG_NOTIFY_ALREADY_OFF.send(sender);
                return;
            }
            LogNotify.setIgnoring(plugin, uuid, true);
            Message.LOG_NOTIFY_TOGGLE_OFF.send(sender);
            return;
        }
        Message.LOG_NOTIFY_UNKNOWN.send(sender);
    }
}

