/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateBuilder;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateField;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateSqlBuilder;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateStatistics;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.action.DeleteAction;
import me.lucko.luckperms.common.bulkupdate.action.UpdateAction;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentException;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.caffeine.cache.Cache;

public class BulkUpdateCommand
extends SingleCommand {
    private final Cache<String, BulkUpdate> pendingOperations = CaffeineFactory.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public BulkUpdateCommand() {
        super(CommandSpec.BULK_UPDATE, "BulkUpdate", CommandPermission.BULK_UPDATE, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) throws CommandException {
        if (plugin.getConfiguration().get(ConfigKeys.DISABLE_BULKUPDATE).booleanValue()) {
            Message.BULK_UPDATE_DISABLED.send(sender);
            return;
        }
        if (!sender.isConsole()) {
            Message.BULK_UPDATE_MUST_USE_CONSOLE.send(sender);
            return;
        }
        if (args.size() == 2 && args.get(0).equalsIgnoreCase("confirm")) {
            String id = args.get(1);
            BulkUpdate operation = (BulkUpdate)this.pendingOperations.asMap().remove(id);
            if (operation == null) {
                Message.BULK_UPDATE_UNKNOWN_ID.send(sender, id);
                return;
            }
            BulkUpdateCommand.runOperation(operation, plugin, sender);
            return;
        }
        if (args.size() < 2) {
            throw new ArgumentException.DetailedUsage();
        }
        BulkUpdateBuilder bulkUpdateBuilder = BulkUpdateBuilder.create();
        bulkUpdateBuilder.trackStatistics(!args.remove("-s"));
        try {
            bulkUpdateBuilder.dataType(DataType.valueOf(((String)args.remove(0)).toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            Message.BULK_UPDATE_INVALID_DATA_TYPE.send(sender);
            return;
        }
        String action = ((String)args.remove(0)).toLowerCase(Locale.ROOT);
        switch (action) {
            case "delete": {
                bulkUpdateBuilder.action(DeleteAction.create());
                break;
            }
            case "update": {
                if (args.size() < 2) {
                    throw new ArgumentException.DetailedUsage();
                }
                String field = (String)args.remove(0);
                BulkUpdateField queryField = BulkUpdateField.of(field);
                if (queryField == null) {
                    throw new ArgumentException.DetailedUsage();
                }
                String value = (String)args.remove(0);
                bulkUpdateBuilder.action(UpdateAction.of(queryField, value));
                break;
            }
            default: {
                throw new ArgumentException.DetailedUsage();
            }
        }
        Object object = args.iterator();
        while (object.hasNext()) {
            String constraint = (String)object.next();
            String[] parts = constraint.split(" ");
            if (parts.length != 3) {
                Message.BULK_UPDATE_INVALID_CONSTRAINT.send(sender, constraint);
                return;
            }
            BulkUpdateField field = BulkUpdateField.of(parts[0]);
            if (field == null) {
                Message.BULK_UPDATE_INVALID_CONSTRAINT.send(sender, constraint);
                return;
            }
            Comparison comparison = Comparison.parse(parts[1]);
            if (comparison == null) {
                Message.BULK_UPDATE_INVALID_COMPARISON.send(sender, parts[1]);
                return;
            }
            String expr = parts[2];
            bulkUpdateBuilder.filter(field, comparison, expr);
        }
        BulkUpdate bulkUpdate = bulkUpdateBuilder.build();
        if (plugin.getConfiguration().get(ConfigKeys.SKIP_BULKUPDATE_CONFIRMATION).booleanValue()) {
            BulkUpdateCommand.runOperation(bulkUpdate, plugin, sender);
        } else {
            String id = String.format("%04d", ThreadLocalRandom.current().nextInt(10000));
            this.pendingOperations.put((Object)id, (Object)bulkUpdate);
            BulkUpdateSqlBuilder sqlBuilder = new BulkUpdateSqlBuilder();
            sqlBuilder.visit(bulkUpdate);
            String readableSql = sqlBuilder.builder().toReadableString().replace("{table}", bulkUpdate.getDataType().getName());
            Message.BULK_UPDATE_QUEUED.send(sender, readableSql);
            Message.BULK_UPDATE_CONFIRM.send(sender, label, id);
        }
    }

    private static void runOperation(BulkUpdate operation, LuckPermsPlugin plugin, Sender sender) {
        Message.BULK_UPDATE_STARTING.send(sender);
        plugin.getStorage().applyBulkUpdate(operation).whenCompleteAsync((v, ex) -> {
            if (ex == null) {
                plugin.getSyncTaskBuffer().requestDirectly();
                Message.BULK_UPDATE_SUCCESS.send(sender);
                if (operation.isTrackingStatistics()) {
                    BulkUpdateStatistics stats = operation.getStatistics();
                    Message.BULK_UPDATE_STATISTICS.send(sender, stats.getAffectedNodes(), stats.getAffectedUsers(), stats.getAffectedGroups());
                }
            } else {
                ex.printStackTrace();
                Message.BULK_UPDATE_FAILURE.send(sender);
            }
        }, plugin.getBootstrap().getScheduler().async());
    }
}

