/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class ListTracks
extends SingleCommand {
    public ListTracks() {
        super(CommandSpec.LIST_TRACKS, "ListTracks", CommandPermission.LIST_TRACKS, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        try {
            plugin.getStorage().loadAllTracks().get();
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst loading tracks", e);
            Message.TRACKS_LOAD_ERROR.send(sender);
            return;
        }
        Message.TRACKS_LIST.send(sender, plugin.getTrackManager().getAll().keySet().stream().sorted().collect(Collectors.toList()));
    }
}

