/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.webeditor.WebEditorRequest;
import me.lucko.luckperms.common.webeditor.WebEditorSession;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.node.Node;

public class TrackEditor
extends ChildCommand<Track> {
    public TrackEditor() {
        super(CommandSpec.TRACK_EDITOR, "editor", CommandPermission.TRACK_EDITOR, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Track target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        plugin.getSyncTaskBuffer().requestDirectly();
        ArrayList<Group> groups = new ArrayList<Group>();
        WebEditorRequest.includeMatchingGroups(groups, target::containsGroup, plugin);
        groups.removeIf(holder -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)ImmutableContextSetImpl.EMPTY));
        if (groups.isEmpty()) {
            Message.EDITOR_NO_MATCH.send(sender);
            return;
        }
        ArrayList<PermissionHolder> users = new ArrayList<PermissionHolder>();
        if (!groups.isEmpty()) {
            List<ConstraintNodeMatcher<Node>> matchers = groups.stream().map(group -> StandardNodeMatchers.key(Inheritance.key(group.getName()))).collect(Collectors.toList());
            WebEditorRequest.includeMatchingUsers(users, matchers, true, plugin);
        }
        users.removeIf(holder -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder));
        ArrayList<PermissionHolder> holders = new ArrayList<PermissionHolder>(groups.size() + users.size());
        holders.addAll(groups);
        holders.addAll(users);
        Message.EDITOR_START.send(sender);
        WebEditorSession.create(holders, Collections.singletonList(target), sender, label, plugin).open();
    }
}

