/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.luckperms.common.cache.ExpiringCache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.calculator.ForwardingContextCalculator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.StaticContextCalculator;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ContextManager<S, P extends S> {
    protected final LuckPermsPlugin plugin;
    private final Class<S> subjectClass;
    private final Class<P> playerClass;
    private final CalculatorList calculators = new CalculatorList();
    private final StaticLookupCache staticLookupCache = new StaticLookupCache();

    protected ContextManager(LuckPermsPlugin plugin, Class<S> subjectClass, Class<P> playerClass) {
        this.plugin = plugin;
        this.subjectClass = subjectClass;
        this.playerClass = playerClass;
    }

    public Class<S> getSubjectClass() {
        return this.subjectClass;
    }

    public Class<P> getPlayerClass() {
        return this.playerClass;
    }

    public abstract UUID getUniqueId(P var1);

    public abstract QueryOptions getQueryOptions(S var1);

    public ImmutableContextSet getContext(S subject) {
        return this.getQueryOptions(subject).context();
    }

    public QueryOptions getStaticQueryOptions() {
        return (QueryOptions)this.staticLookupCache.get();
    }

    public ImmutableContextSet getStaticContext() {
        return this.getStaticQueryOptions().context();
    }

    public void customizeStaticQueryOptions(QueryOptions.Builder builder) {
    }

    public void customizeQueryOptions(S subject, QueryOptions.Builder builder) {
    }

    public void signalContextUpdate(S subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        this.invalidateCache(subject);
        this.plugin.getEventDispatcher().dispatchContextUpdate(subject);
    }

    public abstract void invalidateCache(S var1);

    public void registerCalculator(ContextCalculator<? super S> calculator) {
        String calculatorClass = calculator.getClass().getName();
        Set<Predicate<String>> disabledCalculators = this.plugin.getConfiguration().get(ConfigKeys.DISABLED_CONTEXT_CALCULATORS);
        for (Predicate<String> disabledPattern : disabledCalculators) {
            if (!disabledPattern.test(calculatorClass)) continue;
            this.plugin.getLogger().info("Ignoring registration of disabled context calculator: " + calculatorClass);
            return;
        }
        this.calculators.add(calculator);
    }

    public void unregisterCalculator(ContextCalculator<? super S> calculator) {
        this.calculators.remove(calculator);
    }

    protected void callContextCalculator(ContextCalculator<? super S> calculator, S subject, ContextConsumer consumer) {
        try {
            calculator.calculate(subject, consumer);
        }
        catch (Throwable e) {
            this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating the context of subject " + String.valueOf(subject), e);
        }
    }

    protected void callStaticContextCalculator(StaticContextCalculator calculator, ContextConsumer consumer) {
        try {
            calculator.calculate(consumer);
        }
        catch (Throwable e) {
            this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating static contexts", e);
        }
    }

    protected QueryOptions calculate(S subject) {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        ContextConsumer consumer = accumulator::add;
        for (ContextCalculator calculator : this.calculators.calculators()) {
            this.callContextCalculator(calculator, subject, consumer);
        }
        QueryOptions.Builder builder = this.plugin.getConfiguration().get(ConfigKeys.GLOBAL_QUERY_OPTIONS).toBuilder().context(accumulator.build());
        this.customizeQueryOptions(subject, builder);
        return builder.build();
    }

    private QueryOptions calculateStatic() {
        ImmutableContextSetImpl.BuilderImpl accumulator = new ImmutableContextSetImpl.BuilderImpl();
        ContextConsumer consumer = accumulator::add;
        for (StaticContextCalculator calculator : this.calculators.staticCalculators()) {
            this.callStaticContextCalculator(calculator, consumer);
        }
        QueryOptions.Builder builder = this.plugin.getConfiguration().get(ConfigKeys.GLOBAL_QUERY_OPTIONS).toBuilder().context(accumulator.build());
        this.customizeStaticQueryOptions(builder);
        return builder.build();
    }

    public ImmutableContextSet getPotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (ContextCalculator contextCalculator : this.calculators.calculators()) {
            ContextSet potentialContexts;
            try {
                potentialContexts = contextCalculator.estimatePotentialContexts();
            }
            catch (Throwable e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(contextCalculator) + " whilst estimating potential contexts", e);
                continue;
            }
            builder.addAll(potentialContexts);
        }
        return builder.build();
    }

    private static String getCalculatorClass(ContextCalculator<?> calculator) {
        Class<?> calculatorClass = calculator instanceof ForwardingContextCalculator ? ((ForwardingContextCalculator)calculator).delegate().getClass() : calculator.getClass();
        return calculatorClass.getName();
    }

    private final class CalculatorList {
        private final List<ContextCalculator<? super S>> calculators = new ArrayList();
        private final List<StaticContextCalculator> staticCalculators = new ArrayList<StaticContextCalculator>();
        private volatile ContextCalculator<? super S>[] calculatorsArray;
        private volatile StaticContextCalculator[] staticCalculatorsArray;

        CalculatorList() {
            this.bake();
        }

        private void bake() {
            this.calculatorsArray = this.calculators.toArray(new ContextCalculator[0]);
            this.staticCalculatorsArray = this.staticCalculators.toArray(new StaticContextCalculator[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ContextCalculator<? super S> calculator) {
            CalculatorList calculatorList = this;
            synchronized (calculatorList) {
                this.calculators.add(0, calculator);
                if (calculator instanceof StaticContextCalculator) {
                    StaticContextCalculator staticCalculator = (StaticContextCalculator)calculator;
                    this.staticCalculators.add(0, staticCalculator);
                }
                this.bake();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ContextCalculator<? super S> calculator) {
            CalculatorList calculatorList = this;
            synchronized (calculatorList) {
                this.calculators.remove(calculator);
                if (calculator instanceof StaticContextCalculator) {
                    this.staticCalculators.remove(calculator);
                }
                this.bake();
            }
        }

        public ContextCalculator<? super S>[] calculators() {
            return this.calculatorsArray;
        }

        public StaticContextCalculator[] staticCalculators() {
            return this.staticCalculatorsArray;
        }
    }

    private final class StaticLookupCache
    extends ExpiringCache<QueryOptions> {
        StaticLookupCache() {
            super(50L, TimeUnit.MILLISECONDS);
        }

        @Override
        public @NonNull QueryOptions supply() {
            return ContextManager.this.calculateStatic();
        }
    }
}

